/**
 * Resource service test cases
 * @author Simon Willan <simon.willan@claromentis.com>
 */
(function () {
    'use strict';

    describe('Resources service', function () {
        // $httpBackend is a fake backend service for angular. Can utilize ngResource.
        var quizResources, $httpBackend;

        // load cla.quiz
        beforeEach(angular.mock.module('cla.quiz'));

        // set out injected resources factory
        beforeEach(angular.mock.inject(function ($injector) {
            $httpBackend = $injector.get('$httpBackend');
            quizResources = $injector.get('quizResources');
        }));

        // simple existent check
        it('should exist.', function () {
            expect(quizResources).toBeDefined();
        });

        // resource method
        describe('.getQuiz()', function () {

            // check getQuiz returns a $promise from a resource request.
            it('should check that the endpoint is accessible. (returns a promise).', function () {
                $httpBackend.expectGET('/api/quiz/v1/1')
                    .respond({});

                var result = quizResources.getQuiz(1);
                $httpBackend.flush();

                // test promise is returned, and promise is resolved.
                expect(result.$promise).toEqual(jasmine.any(Object));
                expect(result.$resolved).toBe(true);
            });

        });

        // resource method
        describe('.startQuiz()', function () {

            // check startQuiz returns a $promise from a resource request.
            it('should check that the endpoint is accessible. (returns a promise).', function () {
                $httpBackend.expectPOST('/api/quiz/v1/1/start')
                    .respond({});

                var result = quizResources.startQuiz(1);
                $httpBackend.flush();

                // test promise is returned, and promise is resolved.
                expect(result.$promise).toEqual(jasmine.any(Object));
                expect(result.$resolved).toBe(true);
            });

        });

        // resource method
        describe('.submitQuestion()', function () {

            // check submitQuestion returns a $promise from a resource request.
            it('should check that the endpoint is accessible. (returns a promise)', function () {
                $httpBackend.expectPOST('/api/quiz/v1/1/questions/1/answer')
                    .respond({});

                var result = quizResources.submitQuestion(1, 1, {});
                $httpBackend.flush();

                // test promise is returned, and promise is resolved.
                expect(result.$promise).toEqual(jasmine.any(Object));
                expect(result.$resolved).toBe(true);
            });

        });

        // end quiz method
        describe('.finishQuiz()', function () {

            it('should check that the endpoint is accessible. (returns a promise)', function () {

                $httpBackend.expectPOST('/api/quiz/v1/1/finish')
                    .respond({});

                var result = quizResources.finishQuiz(1);
                $httpBackend.flush();

                // test promise is returned, and promise is resolved.
                expect(result.$promise).toEqual(jasmine.any(Object));
                expect(result.$resolved).toBe(true);

            });

        });

        // get quiz results
        describe('.getResults()', function () {

            it('should check that the endpoint is accessible. (returns a promise)', function () {

                $httpBackend.expectGET('/api/quiz/v1/1/results')
                    .respond({});

                var result = quizResources.getResults(1);
                $httpBackend.flush();

                // test promise is returned, and promise is resolved.
                expect(result.$promise).toEqual(jasmine.any(Object));
                expect(result.$resolved).toBe(true);

            });

        });
    });
}());
