<?php
if (!defined('INSTALL_PROGRESS'))
	die("This file cannot be executed directly");

if (!isset($installer))
	throw new Exception("Install options are not defined");

/** @var $installer \Claromentis\Setup\SetupFacade */

$plugins = $installer->GetPluginsRepository();
$plugins->Add('rssreader', 'Claromentis\RssReader\Plugin');

$db = $installer->GetDb();
// add the rss_feeds metadata field if it doesn't already exist

list($rss_field_count) = $db->query_row("SELECT COUNT(id) FROM ERMS_metadata_field where name='rss_feeds'");
if (!$rss_field_count)
{
	// get the id of the Users metadata set, as well as the maximum ordering of the fields within it
	list($set_id, $set_order) = $db->query_row("SELECT ms.id, MAX(msf.display_order) FROM metadata_set ms INNER JOIN metadata_set_fields msf ON msf.set_id = ms.id  WHERE ms.name='Users' GROUP BY ms.id");

	// add the new field and get the id
	$db->query("INSERT INTO ERMS_metadata_field (name, title, editable, repeatable, meta_type, meta_html_type, implicit, inheritable, visible, mandatory) VALUES ('rss_feeds', 'RSS Feeds', 1, 1, 0, 0, 0, 0, 0, 0)");
	$new_field_id = $db->insertId();

	// add the new field to the metadata set
	$order = $set_order + 1;
	$db->query("INSERT INTO metadata_set_fields VALUES (int:set_id, int:new_field_id, int:order)", $set_id, $new_field_id, $order);
}


