<?php
namespace Claromentis\RssReader\UI;

use Claromentis\Core\Application;
use Claromentis\Core\Component\PagesTemplaterComponent;
use Claromentis\Core\Templater\Plugin\TemplaterComponent;

/**
 * Rss Feed templater component
 */
class Feed implements TemplaterComponent
{
	use PagesTemplaterComponent;

	public function Show($attributes, Application $app)
	{
		$feeds_arr = [];
		foreach ($attributes as $key=>$value)
		{
			if (substr($key, 0, 5) === 'feed_' && !empty($value))
				$feeds_arr[] = $value;
		}
		if (!empty($feeds_arr))
			$attributes['feed'] = implode("\n", $feeds_arr);

		/** @var PagesRssReader $pc */
		$pc = $app['pages.component.rssreader'];
		$options = $this->AttributesToOptions($pc, $attributes);
		$id = isset($attributes['id']) ? $attributes['id'] : uniqid('rss');

		return $this->ShowComponent($id, $pc, $options, $app);
	}
}
