<?php
namespace Claromentis\RssReader\View;

/**
 * Displays list of feed items
 */
class FeedItemsView
{
	/**
	 * How many sentences of the summary to display
	 *
	 * @var int
	 */
	private $summary_length = 0;

	/**
	 * Set the the length of the summary
	 *
	 * @param $length
	 */
	public function SetSummaryLength($length)
	{
		$this->summary_length = $length;
	}

	/**
	 * ShowItems - render RSS feed items and return a datasource array to be used for templater
	 *
	 * @param \SimplePie_Item[] $feed_items
	 *
	 * @return array
	 */
	public function ShowItems(array $feed_items)
	{
		$result = [];

		/** @var \SimplePie_Item $item */
		foreach ($feed_items as $item)
		{
			//vard2($item);
			$arr = array();

			$arr["nf_link.href"] = $this->HtmlDecode($item->get_permalink());
			$d = new \Date($item->get_date('U'));
			$arr["nf_pubdate.body"] = $d->getDate(DATE_FORMAT_CLA_DATETIME);//$item->get_date('j F Y | g:i a');;
			$arr["nf_title.body"] = $this->HtmlDecode($this->HtmlDecode(strip_tags($item->get_title())));

			if ($this->summary_length > 0)
			{
				$summary = $this->FormatSummary($item->get_description()); //$item->{'content:encoded'};
				if ($summary != '')
				{
					$arr['summary_visible.visible'] = 1;
					$arr['summary.visible'] = 1;
					$arr['summary.body_html'] = $summary;
				}
			}


			$result[] = $arr;
		}

		return $result;
	}

	protected function FormatSummary($summary_html)
	{
		/*require_once('html_safe.php');

		$safe_html = safetyHtmlMailReplace($summary_html);
		$safe_html = trim(preg_replace("/<(br|img)((>)|(\s+.*?>))/isu", '', $safe_html));

		return \ClaText::TrimLongHtml($safe_html, $this->summary_length);*/
		return htmlspecialchars(trim_long_string($this->HtmlDecode(strip_tags($summary_html)), $this->summary_length), ENT_COMPAT);
	}

	private function HtmlDecode($text)
	{
		return html_entity_decode($text, ENT_QUOTES | ENT_XML1, 'UTF-8');
	}
}
