# RSS Reader component #

[![](screenshot.png)](screenshot.png)

### Installation ###

Via composer:
  * Add `"claromentis/rssreader": "*"` to `modules.json`
  * From the application folder, run `./clc resolve` (or `clc.bat resolve` on Windows)

Manually:
  * Copy/clone the code into 'intranet/rssreader/' folder
  * Run:

```sh
./clc app:install rssreader
```

...or if there is a previous version of this module is installed, run:

```sh
./clc app:upgrade rssreader
```

### Configuration ###

No config is now required, the 'rss_feeds' metadata key is now created automatically.


### Usage ###

For home page use:

You can hard code multiple feed tags to have feeds that will always be present. This version of RSSReader can be used multiple times on a page as long as you supply a unique id attribute. If no id is supplied the id 'default' is used.  These feeds are not editable by the user.

```html
<component class_key="rssreader.feed" display="3"
       feed_1="http://feeds.bbci.co.uk/news/rss.xml"
       feed_2="http://rss.cnn.com/rss/money_latest.rss" id="staticNewsFeeds" />
```

This also allows multiple instances of FeedReader to be used for single RSS feeds. For example: in multiple tabs within a page component.

```html
<component class_key="rssreader.feed" display="3"
       feed_1="http://feeds.bbci.co.uk/news/rss.xml"
       id="bbcNewsFeed" />
<component class_key="rssreader.feed" display="3"
       feed_1="http://rss.cnn.com/rss/money_latest.rss"
       id="cnnNewsFeed" />
```

Optionally you can specify a metadata key that will also let users add/edit their own RSS feeds
The metadata key is 'rss_feeds' and it automatically added to the user metadata set on installation/upgrade. There can be only one instance of this version of RSSReader on a page and it uses the 'defaultMetakey' id.  Make sure you don't create an id that clashes with this. 

```html
<component class_key="rssreader.feed" metakey="rss_feeds" display="3" />
```

Multiple feeds will be merged and displayed in date/time order, most recent first. The display attribute is how many entries to display, up to a limit of 100 (default is 10) 

The summary_length attribute can be used to control how many characters of a summary/description will be shown. This defaults to 0 (off).

If a feed has an invalid date, it will still show but without date information. If multiple feeds are shown, this feed will therefore be sorted to the end of the list and may not be seen.

If there are no feeds the component will be displayed empty with ability to add custom feeds.