<?php
namespace Claromentis\RssReader\View;

use Claromentis\Core\Component\TemplaterTrait;

/**
 * Customizabe RSS feed view
 */
class CustomizableView extends FeedView
{
	use TemplaterTrait;

	protected $attr_urls;
	protected $user_urls;
	protected $attributes;
	protected $display_edit_link;

	/**
	 * Output information
	 * @var array
	 */
	private $errors = array();

	/**
	 * Metadata Key
	 *
	 * @var
	 */
	private $metakey;

	/** @var array $args */
	private $args = [];

	/**
	 * FeedView constructor.
	 *
	 * @param string[] $attr_urls
	 * @param string[] $user_urls
	 * @param string $metakey
	 * @param array $attributes
	 */
	public function __construct($attr_urls, $user_urls, $metakey, $attributes)
	{
		$this->attr_urls = $attr_urls;
		$this->user_urls = $user_urls;
		$this->metakey = $metakey;
		$this->attributes = $attributes;

		$this->args = [];
	}

	/**
	 * Add errors for display
	 *
	 * @param $errors
	 */
	public function AddErrors($errors)
	{
		if (is_array($errors))
		{
			$this->errors = array_merge($this->errors, $errors);
		} else
		{
			$this->errors[] = $errors;
		}
	}

	/**
	 * ShowItems - Take information from temporary data store and render into an output format
	 *
	 */
	public function Show()
	{
		$this->args = [];

		$this->args['nf_metakey.value'] = $this->metakey;
		$this->args['edit_link_visible.visible'] = $this->display_edit_link;

		$this->args['nf_feed_list.datasrc'] = $this->ShowUrlsList();

		$feed_items_view = new FeedItemsView();
		$feed_items_view->SetSummaryLength($this->summary_length);

		$this->args["nf_data.datasrc"] = $feed_items_view->ShowItems($this->feed_items);

		foreach ($this->errors as $error)
		{
			if ($error)
			{
				$this->args["errors.datasrc"][]['error.body'] = $error;
			}
		}

		$this->args['attributes.value'] = json_encode($this->attributes);

		return $this->CallTemplater('rssreader/feed.html', $this->args);
	}

	protected function ShowUrlsList()
	{
		$result = [];
		foreach ($this->attr_urls as $url)
		{
			$feed_arr = array();
			$feed_arr["nf_url_desc.body"] = $url;
			$feed_arr["nf_url_desc.href"] = $url;

			$feed_arr["nf_url_row.data-id"] = 0;
			$feed_arr["nf_edit.visible"] = 0;
			$feed_arr["nf_delete.visible"] = 0;

			$result[] = $feed_arr;
		}

		foreach ($this->user_urls as $id => $url)
		{
			$feed_arr = array();
			$feed_arr["nf_url_desc.body"] = $url;
			$feed_arr["nf_url_desc.href"] = $url;

			$feed_arr["nf_url_row.data-id"] = $id;
			$feed_arr['nf_url_desc.data-href'] = $url;

			/*$default = $this->metadata->GetPrototype($this->metakey)->GetDefaultValue();
			if (count($this->user_urls) === 1 && $url === $default)
			{
				$feed_arr["nf_delete.visible"] = 0;
			}*/
			$result[] = $feed_arr;
		}
		return $result;
	}

	public function SetDisplayEditLink($visible)
	{
		$this->display_edit_link = $visible;
	}
}