jQuery(document).ready(function () {
	var rssFeedList = $('.tile-rss-reader-component');
	$.each(rssFeedList, function (i, elem) {
		rssFeedInit(elem);
	});
});

function rssFeedInit(elem) {
	var rssReader = $(elem);

	if (!rssReader.find('.js-nf-edit-rss').length) {
		return;
	}

	if (rssReader.data('init-done')) {
		return;
	}
	rssReader.data('init-done', 1);

	var rssfeed_attribs = rssReader.find('.js-nf-component-attributes').val();
	rssfeed_attribs = JSON.parse(rssfeed_attribs);

	// toggle rss form
	rssReader.on('click', '.js-nf-edit-rss', function (e) {
		e.preventDefault();

		rssReader.find(".rss-edit").toggleClass("d-none");
	});

	function showUpdatedFeed(html) {
		rssReader.find('.js-tile-body').html(html);
		rssfeed_attribs = rssReader.find('.js-nf-component-attributes').val();
		rssfeed_attribs = JSON.parse(rssfeed_attribs);
	}

	// hide urls list and cancel "edit" mode
	rssReader.on('click', '.js-nf_cancel_button', function (e) {
		e.preventDefault();

		rssReader.find(".rss-edit").addClass("d-none");
	});

	// show 'add' form
	rssReader.on('click', '.js-nf_add_button', function (e) {
		e.preventDefault();

		rssReader.find(".js-nf_edit_mode_buttons").hide();

		var form = rssReader.find(".js-nf_edit_form");

		form.find(".js-nf_submit_edit").hide();
		form.find(".js-nf_submit_add").show();

		form.find("input[name=nf_edit_id]").val('');
		form.find("input[name=rssfeed_url]").val('');
		form.find("input[name=nf_edit_mode]").val('add');

		form.show();
	});

	rssReader.on('click', '.js-nf_edit', function () {
		var url_id = jQuery(this).closest('tr').data("id");
		var feed = jQuery(this).parent().parent();
		var link = feed.find(".js-nf_url_desc").attr('href');

		rssReader.find(".js-nf_edit_mode_buttons").hide();

		var form = rssReader.find(".js-nf_edit_form");

		form.find(".js-nf_submit_edit").show();
		form.find(".js-nf_submit_add").hide();

		form.find("input[name=nf_edit_id]").val(url_id);
		form.find("input[name=rssfeed_url]").val(link);
		form.find("input[name=nf_edit_mode]").val('edit');

		form.show();

		return false;
	});

	// Cancel button
	rssReader.on('click', ".js-nf_submit_cancel", function (e) {
		e.preventDefault();

		rssReader.find(".js-nf_edit_form").hide();
		rssReader.find(".js-nf_edit_mode_buttons").show();
	});

	// Submit new URL
	rssReader.on('click', ".js-nf_submit_add", function (evt) {
		evt.preventDefault();
		var data =
			{
				rssfeed_url: rssReader.find('input[name=rssfeed_url]').val(),
				metakey: rssReader.find('input[name=nf_metakey]').val(),
				attributes: rssfeed_attribs
			};

		jQuery.ajax('/api/rssreader/v1/',
			{
				method: 'POST',
				contentType: 'application/json',
				data: JSON.stringify(data),
				dataType: 'json',
				success: function (data, textStatus, xhr) {
					if (data.error === true) {
						cla.showMessage(data.message, '', true);
					} else {
						showUpdatedFeed(data.feeds);

						cla.showMessage(lmsg('rssreader.feed_added'), '', false);
					}
				},
				error: function (xhr) {
					var message = xhr.responseJSON !== undefined ? xhr.responseJSON.message : xhr.responseText;
					cla.showMessage(message, '', true);
				}
			});
	});

	// Edit existing URL
	rssReader.on('click', ".js-nf_submit_edit", function (evt) {
		evt.preventDefault();

		var id = rssReader.find('input[name=nf_edit_id]').val();
		var url = rssReader.find('input[name=rssfeed_url]').val();

		var data =
			{
				rssfeed_url: url,
				metakey: rssReader.find('input[name=nf_metakey]').val(),
				attributes: rssfeed_attribs
			};

		jQuery.ajax('/api/rssreader/v1/' + id + '/',
			{
				method: 'PUT',
				data: JSON.stringify(data),
				contentType: 'application/json',
				dataType: 'json',
				success: function (data, textStatus, xhr) {
					if (data.error === true) {
						cla.showMessage(data.message, '', true);
					} else {
						showUpdatedFeed(data.feeds);
						cla.showMessage(lmsg('rssreader.feed_updated'), '', false);
					}
				},
				error: function (xhr) {
					var message = xhr.responseJSON !== undefined ? xhr.responseJSON.message : xhr.responseText;
					cla.showMessage(message, '', true);
				}
			});
	});

	// Delete a URL
	rssReader.on('click', '.js-nf_delete', function (evt) {
		evt.preventDefault();

		//var response = confirm(lmsg('common.confirm_delete_ask'));
		var response = confirm('Are you sure you want to delete this?');
		if (!response) {
			return;
		}

		var id = jQuery(this).closest('tr').data('id');

		var data =
			{
				metakey: rssReader.find('input[name=nf_metakey]').val(),
				attributes: rssfeed_attribs
			};

		jQuery.ajax('/api/rssreader/v1/' + id + '/',
			{
				method: 'DELETE',
				data: JSON.stringify(data),
				contentType: 'application/json',
				dataType: 'json',
				success: function (data, textStatus, xhr) {
					if (data.error === true) {
						cla.showMessage(data.message, '', true);
					}
					else {
						showUpdatedFeed(data.feeds);
						cla.showMessage(lmsg('rssreader.feed_deleted'), '', false);
					}
				},
				error: function (xhr) {
					var message = xhr.responseJSON !== undefined ? xhr.responseJSON.message : xhr.responseText;
					cla.showMessage(message, '', true);
				}
			});
	});
}
