<?php
$_db_migration_to = '10.01'; // 6.0.0-alpha
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_admins_to_slider_managers.php', <<<'DB_UPDATE_FILE'
<?php

$PERMS_CLASS_SLIDER = 150; // Slider::PERMS_CLASS_SLIDER
$PERMS_OCLASS_INDIVIDUAL = 1; // PermOClass::INDIVIDUAL
$PERM_RIGHT_MANAGE_ALL = 3; // Slider\Permissions::PERM_RIGHT_MANAGE_ALL

/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$db = $migrations->GetDb();

// Look up Slider administrators
$res = $db->query('SELECT user_id FROM simple_acl WHERE object_code eq:str:app_name', 'slider');
while ($arr = $res->fetchArray())
{
	$user_id = (int)$arr['user_id'];

	// Add the administrator as a slider manager with full permissions
	$db->unsafe_query = true;
	$db->query('INSERT INTO permissions (class_id, object_id, perm_owner_class_id, perm_owner_id, rights) VALUES (int:class_id, 1, int:perm_owner_class_id, int:perm_owner_id, int:rights)',
		$PERMS_CLASS_SLIDER,
		$PERMS_OCLASS_INDIVIDUAL,
		$user_id,
		$PERM_RIGHT_MANAGE_ALL
	);
}

DB_UPDATE_FILE
);


$migrations->Run('02_slide_schema_changes.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$db = $migrations->GetDb();

// Add background colour column
$db->AddColumn('slider_slide', 'background_colour', 'VARCHAR(10) NULL');

// Add overlay columns
$db->AddColumn('slider_slide', 'overlay_colour', 'VARCHAR(10) NULL');
$db->AddColumn('slider_slide', 'overlay_position', 'INT NOT_NULL DEFAULT 0');
$db->AddColumn('slider_slide', 'overlay_opacity', 'FLOAT NOT_NULL DEFAULT 0.5');
$db->AddColumn('slider_slide', 'overlay_padding', 'INT NOT_NULL DEFAULT 10');

// Migrate generic target column to boolean for "open in new tab"
$db->AddColumn('slider_slide', 'open_new_tab', 'BOOL NOT_NULL DEFAULT false');
$db->query('UPDATE slider_slide SET open_new_tab = 1 WHERE target eq:str:new', '_blank');
$db->DropColumn('slider_slide', 'target');

// Rename kicker to subtitle
$db->AlterColumn('slider_slide', 'kicker', 'subtitle');
$db->AlterColumn('slider_slide', 'kicker_color', 'subtitle_colour');

// Not needed but it would be the only one left with US spelling
$db->AlterColumn('slider_slide', 'title_color', 'title_colour');

DB_UPDATE_FILE
);


$migrations->Run('03_add_slide_thumbnails.php', <<<'DB_UPDATE_FILE'
<?php

use Claromentis\Core\CDN;
use Claromentis\Core\Services;

/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

/** @var CDN\Mirror $cdn */
$cdn = Services::I()->GetCDN();

// It should always be one of these CDN classes that adds the `GetLocalPath` method to CDNInterface
if (!($cdn instanceof CDN\Mirror || $cdn instanceof CDN\Local || $cdn instanceof CDN\FilesystemCDN)) {
	throw new \RuntimeException('Unexpected CDN type: ' . get_class($cdn));
}

if (!$cdn->IsDir('slider/thumbs'))
	$cdn->CreateDir('slider/thumbs');

$temp_path = create_temp_path();
$res = $db->query('SELECT id FROM slider_slide');
while ($arr = $res->fetchArray())
{
	$slide_id = (int)$arr['id'];
	if (!$cdn->Exists('slider/' . $slide_id . '.jpg'))
		continue;

	$path = $cdn->GetLocalPath('slider/' . $slide_id . '.jpg');

	$thumb_filename = $slide_id . '.jpg';

	try
	{
		ClaImage::Resize($path, $temp_path . $thumb_filename, 70, 50);
		$cdn->Add($temp_path . $thumb_filename, 'slider/thumbs/' . $thumb_filename);
	} catch (\Claromentis\Core\Imager\Exception\ImagerException | Exception $e)
	{
		// Do nothing to avoid breaking the upgrade process
	}
}
rmdir_r($temp_path);

DB_UPDATE_FILE
);


$migrations->Run('03_convert_vertical_sliders.php', <<<'DB_UPDATE_FILE'
<?php

$STYLE_VERTICAL = 1; // Slider::STYLE_VERTICAL
$STYLE_HORIZONTAL = 2; // Slider::STYLE_HORIZONTAL

/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$db = $migrations->GetDb();

$db->unsafe_query = true;
$db->query('UPDATE slider SET style eq:int:horizontal WHERE style eq:int:vertical', $STYLE_HORIZONTAL, $STYLE_VERTICAL);

DB_UPDATE_FILE
);


$migrations->Run('04_slide_default_opacity.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$db = $migrations->GetDb();

$db->AlterColumn('slider_slide', 'overlay_opacity', 'overlay_opacity', 'FLOAT NOT_NULL DEFAULT 0.9');

DB_UPDATE_FILE
);


$migrations->Run('05_slide_schema_renaming.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * @var $migrations \Claromentis\Setup\SetupFacade
 */
$db = $migrations->GetDb();

// Rename colour to color
$db->AlterColumn('slider_slide', 'background_colour', 'background_color');
$db->AlterColumn('slider_slide', 'overlay_colour', 'overlay_color');
$db->AlterColumn('slider_slide', 'subtitle_colour', 'subtitle_color');
$db->AlterColumn('slider_slide', 'title_colour', 'title_color');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('10.01');
