(function(){
  var sortableOptions = {
	handle: '.js-drag-handle',
    items: 'tr',
    helper: function(e,tr){
    var $originals = tr.children();
     var $helper = tr.clone();
     $helper.children().each(function(index) {
       // Set helper cell sizes to match the original sizes
       $(this).width($originals.eq(index).width());
     });
     return $helper;
    },
    update: updateSlidePosition
  };

	$(document).ready( function() {
        // Update component code example as User enters slider Key
          $('#slider_key').on('keyup', sliderKeyTxt);

        // Show selected slider appearance image
          $('.js-appearance').on('change', showImage);

        // Active default slider appearance image
          $('.js-appearance:checked').each(showImage);

        // Link target change
        $('#target_select').on('change', targetSelect);

            // Using jQuery UI Sortable (http://api.jqueryui.com/sortable)
        $("#slides-list").sortable(sortableOptions);

        $('.js-toggle-visibility').on('click', function(event) {
            event.preventDefault();

            var element = $(this);
            var enabled = element.data('slide-enabled') === 1;
            var slideId = element.data('slide-id');

            var url = '/api/slider/slide/' + slideId + (enabled ? '/hide' : '/show');

            // Finds the 'hidden' badge associated with the clicked visibility toggle
            var visibilityBadge = $(this).parents('.slide-wrapper').find('.visibility-badge');

            $.ajax({
                method: 'POST',
                url: url,
                data: {}
            })
                .success(function(data) {
                    if (data.error)
                    {
                        cla.showMessage(data.message, '', true);
                        return;
                    }

                    if (data.visible)
                    {
                        element.find('.js-hide-slide').removeClass('slide-visibility-hidden');
                        element.find('.js-show-slide').addClass('slide-visibility-hidden');
                    } else
                    {
                        element.find('.js-show-slide').removeClass('slide-visibility-hidden');
                        element.find('.js-hide-slide').addClass('slide-visibility-hidden');
                    }

                    element.data('slide-enabled', data.visible);

                    // Shows or hides 'hidden' badge on click dependent on current visibilty setting
                    if (data.visible !== 0) {
                        visibilityBadge.addClass('d-none');
                    } else {
                        visibilityBadge.removeClass('d-none');
                    }

                    cla.showMessage(data.message);

                })
                .error(function() {
                    cla.showMessage('Unknown error', '', true);
                });
        });

        var original_slider_title = $('#slider_title').val();
        $('#open_slider_edit').on('click', function() {
            $('#slider_title').val(original_slider_title);
        });
	});

  ///////////////////////////

  function updateSlidePosition(event, ui) {
    var slideIDs = [];

    $("#slides-list").find("tr").each(function(index, el) {
      var slideId  = $(el).data('id');
      slideIDs.push( slideId );
    });

    $.ajax({
        method: 'POST',
        url: '/api/slider/slide_order/',
        data: {
            slide_ids: slideIDs
        }
    });
  }

  function targetSelect() {
    var isOther = $(this).val() != 'other';
    $('#targetHelp').toggleClass('d-none', isOther);
  }

	function sliderKeyTxt() {
	  $('#sliderKeyTxt').text(this.value)
	}

	function showImage() {
	  var target = jq_$('Image' + $(this).val()),
        horizontalSlider = $(this).val() == 2;

	  target.removeClass('d-none').siblings().addClass('d-none');
	  $('#horizontalCount').toggleClass('d-none', !horizontalSlider);
	}
})();
