Homepage Slider
===============

The claromentis multi-style homepage slider.

**Horizontal view:**<br />
[![](screenshot2.png)](screenshot2.png)

**Apps view:**<br />
[![](screenshot3.png)](screenshot3.png)

## Install or initial upgrade from a Claromentis 7.1 system
* Copy the content of this repository into /intranet/slider of the destination system
* On the command line on the target system run `phing -Dapp=slider install`

## Upgrade 
* On the command line on the target system run `phing -Dapp=slider upgrade`

To embed within a publish page, use:
```javascript
	<script type="text/javascript">
		<!--
		var smart_slider = {};
		smart_slider.name="slider";
		smart_slider.key="yourSlider_keyname";
		smart_slider.width="735"; // Optional
		smart_slider.height="245"; // Optional
		smart_slider.speed="5"; // Optional
		smart_slider.style="horizontal"; // Optional
		//-->
	</script>
	<script type="text/javascript" src="/intranet/slider/js/smart_slider.js"></script>
```

For home page component:
```html
	<component class="SliderComponent" key="yourSlider_keyname">
```

Home page component attributes:

| Attribute  | Required | Description
| ---------- | -------- | -------------------------------------------------- |
| `key`      | Yes      | The key of the slider to use for this component    |
| `template` | No       | Override for the default html template             |
| `speed`    | No       | How frequently to change slides, in seconds        |

Slider links now support parameter substitution where a placeholder is replaced 
with the correct value when clicked by a user. These placeholders can include most
user profile fields (e.g. username, firstname, surname, etc) as well as custom
metadata (e.g. [m]usr_phone). Password and password hash are not permitted.

To utilise, simple place the field/metadata name inside of double curly brackets.

Examples:
* http://www.example.com/?username={{username}}
* http://www.example.com/?firstname={{firstname}}
* http://www.example.com/?phone={{[m]usr_phone}}

## Configuring App Slider

App slider can be configured by copying slider_apps.html in to slider/ directory in custom VI and modifying the following parameters:

* items : 6, //6 items above 1000px browser width
* itemsDesktop : [1000,5], //5 items between 1000px and 901px
* itemsDesktopSmall : [900,4], // betweem 900px and 601px
* itemsTablet: [600,3], //2 items between 600 and 0
* itemsMobile : [600,2], // itemsMobile disabled - inherit from itemsTablet option
* scrollPerPage : true,
* slideSpeed : 450,
* pagination : true,
* navigation : true,
* navigationText: ["<i class='icon-chevron-left'></i>","<i class='icon-chevron-right'></i>"]

Additionally, the all options of the Owl Carousel are available for customization http://owlgraphic.com/owlcarousel/#customizing 
