<?php
$_db_migration_to = '10.02'; // 6.0.0-alpha2
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('04_convert_pages_options.php', <<<'DB_UPDATE_FILE'
<?php

/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

// Update Slider Pages components to use the slider ID and not the key, which is being deprecated

$res = $db->query("SELECT id, name, value FROM pages_tile_option WHERE name='key' AND tile_id IN (SELECT id FROM pages_tile WHERE class_key eq:str:slider_component)",'slider.slider');
while ($arr = $res->fetchArray())
{
	$row_result = $db->query('SELECT id FROM slider WHERE slider_key eq:str:key', $arr['value']);

	if (!$row_result->hasData())
		continue;

	$slider = $row_result->fetchArray();

	$db->unsafe_query = true;
	$db->query("UPDATE pages_tile_option SET name='slider_id', value eq:int:slider_id WHERE id eq:int:option_id", (int)$slider['id'], (int)$arr['id']);
}

DB_UPDATE_FILE
);


$migrations->Run('05_add_modified_by_data.php', <<<'DB_UPDATE_FILE'
<?php

/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('slider', 'modified_by', 'INT NULL');
$db->AddColumn('slider', 'modified_date', 'INT_DATE NULL');

DB_UPDATE_FILE
);


$migrations->Run('06_add_created_and_modified_by_data_to_slides.php', <<<'DB_UPDATE_FILE'
<?php

/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('slider_slide', 'created_by', 'INT NULL');
$db->AddColumn('slider_slide', 'created_date', 'INT_DATE NULL');
$db->AddColumn('slider_slide', 'modified_by', 'INT NULL');
$db->AddColumn('slider_slide', 'modified_date', 'INT_DATE NULL');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('10.02');
