define(['jquery', '../css/edit-slide.scss'], function($) {

    // Link target change
    $('#target_select').on('change', targetSelect);

    // Display tooltips sectino when tooltips are being used
    $('.js-display-type').on('change', showTooltips);

    // Active tooltips area if enabled
    $('.js-display-type:checked').each(showTooltips);

    // On load, display other text input if 'Link Target' is set to 'Other'
    if ($('#target_select').val() === 'other') {
        $('#targetHelp').removeClass('hide');
    } else {
        $('#targetHelp').addClass('hide');
    }

    updateSlideBackgroundImage();
    updateSlideBackgroundColor();
    updateText();
    updateTextColor();
    updateOverlayPadding();
    updateOverlayOpacity();
    updateOverlayBackground();
    updateOverlayPosition();

    // To show slide validation errors when reloading
    function reportErrors(messages, is_error_message) {
        if (messages.length > 0)
            cla.showMessage(messages, '', is_error_message);
    }

    ///////////////////////////

    function showTooltips() {
    var val = $(this).val(),
      hasTooltips = (val == 2 || val == 3);

    $('#tooltips').toggle(hasTooltips);
    }

    function targetSelect() {
        var isOther = $(this).val() != 'other';
        $('#targetHelp').toggleClass('d-none', isOther);
    }


    // Update slider preview on input

    // Previews the slide background color
    function updateSlideBackgroundImage() {
        var slideBackgroundImage  =  $('.js-current-image').css('background-image');
        $('#slide-preview').css({
            'background-image': slideBackgroundImage,
            'background-size': 'contain',
            'background-repeat' : 'no-repeat',
            'background-position': 'center'
        });
    }

    // Previews the slide background color
    function updateSlideBackgroundColor() {
        var slideBackgroundColor  =  $('#slide_background').val();
        $('#slide-preview').css('background-color', slideBackgroundColor);
    }

    // Previews the slide title and subtitle text, if there is no text preset the overlay will be hidden.
    function updateText() {
        var titleText =  $('#title').val();
        var subtitleText = $('#subtitle').val();
        if (subtitleText === '' && titleText === '') {
            $('#slide-preview-overlay').addClass('d-none');
        } else {
            $('#slide-preview-overlay-title').text(titleText);
            $('#slide-preview-overlay-subtitle').text(subtitleText);
            $('#slide-preview-overlay').removeClass('d-none');
        }
    }

    // Previews the slide text color
    function updateTextColor() {
        var textColor = $('#title_color').val();
        $('.slide-preview-overlay-title').css('color', textColor);

        var subtitleColor = $('#subtitle_color').val();
        $('.slide-preview-overlay-subtitle').css('color', subtitleColor);
    }

    // Previews the overlay padding size
    function updateOverlayPadding() {
        var overlayPadding  =  $('#overlay_padding').val();
        $('#slide-preview-overlay').css('padding', overlayPadding + 'px' );

        // Shows overlay padding in 'px' and displays it next to the slider
        $('#overlay-padding-readout').html(overlayPadding + 'px');
    }

    // Previews the overlay background opacity
    function updateOverlayOpacity() {
        var overlayOpacity  =  $('#overlay_opacity').val();
        $('#slide-preview-overlay-bg').css('opacity', overlayOpacity);

        // Shows overlay opacity as a percentage and displays it next to the slider
        var overlayPercentageReadout = overlayOpacity*100;
        $('#overlay-opacity-readout').html(overlayPercentageReadout + '%');

    }

    // Previews the overlay background color
    function updateOverlayBackground() {
        var overlayBackground  =  $('#overlay_background').val();
        $('#slide-preview-overlay-bg').css('background-color', overlayBackground);
    }

    // Previews the overlay background position
    function updateOverlayPosition() {
        // convert saved value to CSS value
        var justifyLookup = {
            top: 'unset',
            middle: 'center',
            bottom: 'flex-end'
        };
        var overlayPosition = $('#overlay_position').val();
        if (justifyLookup[overlayPosition] === undefined)
            overlayPosition = justifyLookup.bottom;
        else
            overlayPosition = justifyLookup[overlayPosition];

        $('#slide-preview').css('justify-content', overlayPosition);
    }


    // Javascript observer which watches the image upload dialog for changes to the slider image
    var target = document.querySelector('.js-current-image');
    if (target) {
        var observer = new MutationObserver(function(mutations) {
            updateSlideBackgroundImage();
        });
        var config = { attributes: true, childList: true, characterData: true };
        observer.observe(target, config);
    }


    $('#slide_background').on('input change', updateSlideBackgroundColor);
    $('#title_color, #subtitle_color').on('input change', updateTextColor);
    $('#title, #subtitle').on('input change keyup', updateText);
    $('#overlay_padding').on('input change', updateOverlayPadding);
    $('#overlay_opacity').on('input change', updateOverlayOpacity);
    $('#overlay_background').on('input change', updateOverlayBackground);
    $('#overlay_position').on('input change', updateOverlayPosition);

    $('.js-reset-slider-color').on('click', function(event) {
        event.preventDefault();
        $(this).parent().find('input').val('').css('background-color', 'white').siblings().css('color', 'black');
        updateSlideBackgroundColor();
    });

    return {
        reportErrors: reportErrors
    };
});
