require("lib.owlcarousel");

require("../css/pages-components/slider_apps.scss");

$ = require('jquery');

var Slider = function (sliderName, slideCount) {
    this.sliderName = sliderName;
    this.$el = $("#carousel-" + this.sliderName);
    this.$container = this.$el.closest('.js-tile-body-container');
    this.slideCount = slideCount;
    this.init();
};

Slider.prototype.init = function () {
    this.initSlider();

    // Listen to Pages events to re-init when a tile is resized
    var self = this;
    this.$container.closest('.js-tile').on('pages-tile-resize pages-tile-add', function(event, element) {
        self.calcDisplaySize();
    });
    $(window).on('resize', function() {
        self.calcDisplaySize();
    });
};

Slider.prototype.calcDisplaySize = function()
{
    this.initSlider();
};

Slider.prototype.initSlider = function()
{
    var owl = this.$el.find(".owl-carousel");
    var items = 3;
    var showPagination = true;

    if (this.slideCount <= 3)
    {
        items = this.slideCount;
        showPagination = false;
    }

    owl.trigger('destroy.owl.carousel').removeClass('owl-carousel owl-loaded');
    owl.find('.owl-stage-outer').children().unwrap();

    owl.owlCarousel({
        items: items,
        scrollPerPage : true,
        autoplayTimeout : 450,
        dots : showPagination,
        nav : showPagination,
        loop: showPagination,
        navText: ['<ion-icon class="d-block" name="chevron-back"></ion-icon>','<ion-icon class="d-block" name="chevron-forward"></ion-icon>'],
    });
}


module.exports = Slider;
