# Slider Change Log

## Unreleased

### Bug fixes

- !28 BT-5861 Disco 053843 Fixed sliders list pagination for users with the "Manage own sliders" permission
- !29 BT-5862 Disco 053843 Fixed default sliders list sort order for users with the "Manage own sliders" permission

## 7.0.2 - 8th August 2025

### Bug fixes

- !27 SLIDER-115 Fixed rounded top corners issue in Slider component

## 7.0.1 - 16th June 2025

### Improvements

- !26 SLIDER-114 Added the option to add a title to the Slider component

## 7.0.0 - 9th June 2025

- Stable release

## 7.0.0-beta - 16th April 2025

- 7006b4d9 BT-5175 Fixed PHP 8 incompatibility issues for Pages components

## 7.0.0-alpha2 - 29th January 2025

### Developer notes

- Merged upstream changes from 6.0.6

## 7.0.0-alpha - 14th November 2024

- FRAM-954 Claromentis 10 compatibility

## 6.0.6 - 28th January 2025

### Bug fix

- !25 BT-3302 Fixed tooltip placement for consistency on slides

## 6.0.5 - 19th June 2024

- !22 BT-4696 French localisation update
- !21 BT-4684 German localisation update

## 6.0.4 - 19th March 2024

### Bug fixes
- !20 BT-4554 Disco 044757 Fixed an issue where an error occurs when visiting the Slide page when there are no slides present.

## 6.0.3 - 13th December 2022

- !18 BOOTY-582 Replaced utility classes usages with Bootstrap 4 standard utility classes

## 6.0.2 - 5th August 2022

* d2e6f447 BOOTY-500 BOOTY-515 BOOTY-519 Updated pages component IDs so they use the new class structure

## 6.0.1 - 11th May 2022
* !17 SLIDER-113 Fixed unescaped text in the "Edit slide" preview title and subtitle
* BOOTY-500 Updated pages component IDs so they use the new class structure
 * BOOTY-515 Slider component
 * BOOTY-519 App Slider component

## 6.0.0 - 8th April 2022
* !16 SLIDER-102 Final design review fixes.

## 6.0.0-beta - 31st March 2022

### Improvements
* !13 SLIDER-69 Slider components both support new options added in SLIDER-11

## 6.0.0-alpha2 - 17th March 2022

### Improvements
* !11 SLIDER-10
  * Added modified by/date fields
  * Slides can be duplicated in the slide list page
  * New slides will default to the same style as the first slide on that slider
* !12 SLIDER-9 Slider list now has thumbnails and last modified date columns

### Developer notes
* !11 SLIDER-10 Removed slider key in favour of using the ID in components/Pages

## 6.0.0-alpha - 28th January 2022

### Improvements
* !8 SLIDER-12 Moved edit functionality from admin panel to a Slider application
* !9 SLIDER-11
  * Updated slide edit page with design updates
  * Slides now have configurable overlay settings (position, colour, opacity, padding)

### Breaking changes
* !10 SLIDER-8 Deprecated vertical sliders
 
### Developer notes
* !8 SLIDER_12 changed all application pages to use routing and controllers.
* FRAM-152 Updated module installation and uninstallation to use CDN interface for appdata directory creation and removal
 
## 5.3.0 - 4th May 2020

### Improvements
* !7 SLIDER-4 Added configurable display options for the Slider Pages component when using a horizontal slider

### Developer notes
* !7 SLIDER-4:
  * Updated PHP dependency to `>=7.1.0, <7.3`
  * Updated Core dependency to `>=8.10`

## 5.2.11 - 4th May 2020

### Improvements
* UIUX-744 Added Fast Access deprecation notice

## 5.2.10 - 17th September 2020
* !5 BT-1986 Fixed slides not being able to be dragged to reorder them when running on Claromentis 8.10

## 5.2.9 - 27th November 2019

### Improvements
* CORE-1036 Added Hungarian translation

## 5.2.8 - 29th October 2019

### Improvements
* Added Uzbek translation

## 5.2.7 - 18th October 2019

### Improvements
* !4 CORE-973 Added Component `App Slider` to Category `Productivity & Shortcuts`.
* !4 CORE-973 Added Component `Slider` to Categories `News & Announcements` and `Productivity & Shortcuts`.

## 5.2.6
* Added Russian translations

## 5.2.5
* Set image display height dimensions for slider so that it appears after uploading via image dialog.
* Changing terminology from Fast Access To App Slider to avoid confusion with new Buttons app.
* Enabling Localisation for Slider App Name in Admin Panel.
* Slide links that open external links in new tabs/windows use rel="noopener" for extra security.

## 5.2.4
* Composer.json compatibility with future versions of core.

## 5.2.3
* Made compatible with future versions of Claromentis

## 5.2.2
* Added German translation
* Design improvements for contrast

## 5.2.1
* UI fixes, improved styles
* Marked as compatible with Claromentis 8.3

## 5.2.0
* UI fixes, improved styles
* Added images thumbnails to admin area

## 5.2.0-rc
* Improved responsiveness and fixed number of small visual issues

## 5.2.0-beta
* Compatibility with Claromentis 8.2
* Major reorganisation and optimisation of the front-end code

## 5.1.5
* Made vertical slider layout code to be more responsive on mobile
* Improved Fast Access buttons display

## 5.1.4
* Fixed vertical slider drawing correctly when a Pages page first loads
* Fixed issue using the same slider source more than once on a page.

## 5.1.3
* Fixed editing and displaying vertical slider

## 5.1.2
* Added option for max number of slides in horizontal slider
* Reduced minimum allowed image sizes

## 5.1.1
* Compatibility with Claromentis 8.1
* Added pages components
* Added new crop tool for adding slides
* Applications slider style is now for fastaccess component only
* Removed ability to set slider style from admin panel
* Added ability to set slider type in component
* Various bugfixes for slider smart object
* Added ability to set style by passing attribute to smart object

## 5.0.4
* Fixed error when showing app-style slider as a smart object

## 5.0.3
* Enable more than 3 slides
* Some style changes

## 5.0.2
* Fixed reference to non-existing template file in horizontal slider

## 5.0.1
* Fixed multiple CSS files causing conflicts by reading and processing slider templates in PHP and not bulk loading them

## 5.0.0
* Claromentis 8 compatibility 

## 4.0.1
* Minor bigfixes

## 4.0.0
* Slider implemented using slider-pro library 

## 3.6.0
* Merged Owl Carousel into master -- these are likely breaking changes if previous VI wasn't using the Owl Carousel version of slider
* Fixed some default styling across all 3 sliders

## 3.5.2
* Fixed slider smart object
* Implemented customisable slider speed

## 3.5.1
* Bugfix: Re-ordering slides was not compatible with load-balancing
* Added BBCode processing for horizontal and vertical sliders

## 3.5
* New: configurable number of slides to display for horizontal slider
* Increased the length of slide link from 256 to 1024 characters

## 3.4
* New: CDN (load balancing) compatibility for slider images
* Requires Claromentis 7.3+
* Fixed bug regarding fields/metadata in slide URLs
* Added in ability to pass custom html templates

## 3.3
* Added placeholder substitution for slider links

## 3.2
* Fully 7.2/phing compatible

## 3.1.4 and 3.1.5
* 7.2 switch - upgraded install/upgrade scripts to new system
* For Claromentis 7.1 systems use v3.1.3

## 3.1.2
* Bugfix: MSSQL compatibility: sql_up scripts had an issue

## 3.1.1
* Bugfix: Smart object: The app slider was not possible to see via smart objects

## 3.1
* Title visibility: Can now select if title, tooltip, both or neither should be shown per slide
* HTML link target: Field per slide to open links in same window, parent window, new window/tab or a specific one
* Colour picker: Now uses KolorPicker component
* Fix: Alternate protocol: Only kclient:// for now but can add them by request
* Fix: URL validation: URLs are now validated

## 3.0
* App Slider: New style of slider that allows icons to links
* Multiple Sliders: JavaScript update to allow multiple sliders on the same page
* Permissions: All slides now use the permissions system to allow custom sliders per role/person
* Tooltips: For title-less slides
* Localisation: Slide titles, nav titles, nav descriptions and tooltip can use the "@{blog.common.blog|Default text}" format of localisation
