<?php
$_db_migration_to = '01.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_schema.php', <<<'DB_UPDATE_FILE'
<?php
$db->CreateTable('slider', array(
	'id'				=> 'IDENTITY',
	'title'				=> 'VARCHAR(100)',
	'kicker'			=> 'VARCHAR(200)',
	'kicker_color'		=> 'VARCHAR(10)',
	'title_color'		=> 'VARCHAR(10)',
	'link'				=> 'VARCHAR(255)',
	'image_name'		=> 'VARCHAR(100)',
	'nav_title'			=> 'VARCHAR(100)',
	'nav_description' 	=> 'VARCHAR(200)',
	'enabled'			=> 'BOOL'
), false);
DB_UPDATE_FILE
);


$migrations->Run('02_multi_slider.php', <<<'DB_UPDATE_FILE'
<?php
$db->RenameTable('slider', 'slider_slide');

$db->AlterColumn('slider_slide', 'enabled', 'enabled', 'INT NOT_NULL DEFAULT 0');

$db->AddColumn('slider_slide', 'slider_id', 'INT');

$db->CreateTable('slider', array(
	'id'           => 'IDENTITY',
	'title'        => 'VARCHAR_MAX',
	'slider_key'   => 'VARCHAR_MAX',
	'style'        => 'INT NOT_NULL DEFAULT 1',
	'created_date' => 'INT_DATE',
	'created_by'   => 'INT'
));

$today = new Date();
// Add a default entry to the slider table
$db->query(new QueryInsert('slider', array(
	'str:title'      => 'Homepage Slider',
	'str:slider_key' => 'homepage_slider',
	'int:created_date'   => $today->getDate(DATE_FORMAT_TIMESTAMP),
	'int:created_by'     => 1
)));

// // Update all existing (old slides) to use the new entry if the table was actually created (not an install over an existing multi-slide system)
$insert_id = $db->insertId();
if ($insert_id > 0)
	$db->query(new QueryUpdate('slider_slide', '1=1', array('int:slider_id' => $insert_id)));
DB_UPDATE_FILE
);


$migrations->Run('03_v1.2.php', <<<'DB_UPDATE_FILE'
<?php
// Incrase the size of the kicker column
$db->AlterColumn('slider_slide', 'kicker', 'kicker', 'VARCHAR_MAX');
DB_UPDATE_FILE
);


$migrations->Run('04_v2.0.php', <<<'DB_UPDATE_FILE'
<?php
$db->AddColumn('slider_slide', 'position', 'INT');
DB_UPDATE_FILE
);


$migrations->Run('05_v2.1.php', <<<'DB_UPDATE_FILE'
<?php
//define(PERM_CLASS_SLIDER_SLIDE, 88);

$db->AddColumn('slider', 'is_smart', 'BOOL DEFAULT 0');
$db->AddColumn('slider_slide', 'tooltip', 'VARCHAR(256) NULL');
$db->AddColumn('slider_slide', 'tooltip_location', 'INT NULL');

// Update all existing slides to have permission for anyone to see
$perm_class = 88;

$res = $db->query('SELECT id FROM slider_slide');

while ($arr = $res->fetchArray())
{
	$perms = new Permissions($perm_class, (int)$arr['id']);
	$perms->Load();
	$perms->Add(PERM_VIEW, PERM_OCLASS_ALL);
	$perms->Save();
}
DB_UPDATE_FILE
);


$migrations->Run('06_v3.0.php', <<<'DB_UPDATE_FILE'
<?php
$db->AddColumn('slider_slide', 'target', 'VARCHAR(256) NULL');

// Update all existing slides to open in their parents frame
$db->query('UPDATE slider_slide SET target = "_parent"');
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.01');
