require("../css/pages-components/fast_access.scss");

$ = require('jquery');

var Slider = function (sliderName) {
    this.sliderName = sliderName;
    this.$el = $("#carousel-" + this.sliderName);
    this.$container = this.$el.closest('.js-tile-body-container');
    // todo: expose as an attribute?
    this.gutter = 9;

    this.init();
};

Slider.prototype.init = function () {

    var self = this;
    self.$el.css('display', 'none');

    setTimeout(function(){
      self.$el.show();
      self.layout();

      //adjust ui-icon position
      self.$container
        .parent().next()
        .css({
          'margin-bottom': '-10px',
          'margin-right': '-5px'
        })
    }, 500);
    var isPages = $('.grid-stack').length > 0;
    if (isPages) {
        this.$container.css('overflow', 'hidden');

        $(window).resize(function () {
            self.layout();
        });

        this.$container.closest('.js-tile').on('pages-tile-resize pages-tile-add', function (event, element) {
            self.layout();
        });
    }

    // CSS adjustment for box shadows
    self.$container.css({
      'width': 'auto',
      'min-height': 'calc(100% + 20px)',
      'padding': '8px',
      'margin': '-8px'
    });
};

Slider.prototype.layout = function () {

    var isPages = $('.grid-stack').length > 0;

    this.$el.closest('.grid-stack-item-content').css('border', 0);

    if (this.$el.length === 0)
        return;

    var area = {
        height: this.$container.innerHeight(),
        width: this.$container.innerWidth()
    }

    //amend container width for box shadow solution
    area.width = area.width - 16;
    area.height = area.height - 20;

    var tileCount = this.$el.find('.slider-button').length;

    var rows = 1;
    var columns = tileCount;
    var ar = (area.height / rows) / (area.width / columns);
    while ((ar > 1.0) && (columns > 1))
    {
        rows++;
        columns = Math.ceil(tileCount / rows);
        ar = (area.height / rows) / (area.width / columns);
    }

    var hGaps = (columns -1) * this.gutter;
    var vGaps = (rows - 1) * this.gutter;
    var cellWidth = (Math.floor(area.width) - hGaps) / columns;
    var cellHeight = (Math.floor(area.height) - vGaps) / rows;

    var currentRow = 0;
    var currentColumn = 0;
    var self = this;
    this.$el.find('li').each(function()
    {
        if (isPages)
        {
              $(this)
                .css('position', 'absolute')
                .css('left', (currentColumn*cellWidth) + (currentColumn * self.gutter))
                .css('top', (currentRow*cellHeight) + (currentRow * self.gutter));
        } else
        {
            if (currentColumn != (columns - 1))
                $(this).css('margin-right', self.gutter);
            if (currentRow != (rows - 1))
                $(this).css('margin-bottom', self.gutter);
        }
        $(this)
            .css('width', cellWidth)
            .css('height', cellHeight);

        currentColumn++;
        if (currentColumn == columns)
        {
            currentColumn = 0;
            currentRow++;
        }
    });
};

module.exports = Slider;
