# Log in with social network accounts supporting OAuth2

Single-sign-on with Google accounts. Works by matching google account email address with the email address configured in
Claromentis user properties.

## Installation

Via composer

```shell
composer require claromentis/socialconnect:"*"
```

Manually:
  * clone this repository to /intranet/socialconnect
  * go to Claromentis base folder (above "web") and run ``php bin/composer.phar update``
  * from the same folder run ``vendor/bin/phing -Dapp=socialconnect install``

## Setting up

Go to "Social Connect" admin panel and follow instructions to create applications in social networks and enable log in integrations. 

Then create links to log in with the required social networks on the main log in page.

```html
<p>
   <a href="/login?social=google&amp;page=##page_url##" title="Sign with Google">
   <img src="/intranet/socialconnect/images/google-sign-in.png" alt="Sign with Google" border="0" />
   </a>
</p>
```

Other social networks can be added in a similar way. The links would be
  * Facebook: `<a href="/login?social=facebook&amp;page=##page_url##">`
  * Twitter: `<a href="/login?social=twitter&amp;page=##page_url##">`
  * Windows Live: `<a href="/login?social=live&amp;page=##page_url##">`
  * Google: `<a href="/login?social=google&amp;page=##page_url##">`

## Usage

When this application is installed, the "My settings" page gets new elements on the "password" tab. Each user individually can
connect their social network account with Claromentis account. Once connected, they will be able to log in to Claromentis
using that social network.
