<?php
namespace Claromentis\SocialConnect\Controller;

use Claromentis\Core\Application;
use Claromentis\Core\Config\Config;
use Claromentis\Core\Http\gpc;
use Claromentis\Core\Http\RedirectResponse;
use Claromentis\Core\Http\TemplaterCallResponse;
use Psr\Http\Message\ServerRequestInterface;

/**
 * Admin panel for Social Connect application
 *
 * @author Alexander Polyanskikh
 */
class AdminController
{
	public function Show(Application $app, ServerRequestInterface $request)
	{
		$args = [];

		$providers_mapping = $app['socialconnect.providers_mapping'];
		$config = $app['socialconnect.opauth_config']['Strategy'];

		$args['this_host.body'] = create_internal_link('/socialconnect');

		foreach ($providers_mapping as $provider_name => $info)
		{
			$key = $info['url'];
			if (isset($config[$provider_name]))
			{
				$config_info = $config[$provider_name];

				$args[$key . '[enabled].checked'] = 1;

				$client_id_key = $info['client_id'];
				$args[$key . '[client_id].value'] = isset($config_info[$client_id_key]) ? $config_info[$client_id_key] : '';

				$client_secret_key = $info['client_secret'];
				$args[$key . '[client_secret].value'] = isset($config_info[$client_secret_key]) ? $this->ObscureSecret($config_info[$client_secret_key]) : '';

                $provider = $app['socialconnect.config']['providers'][$provider_name];
                $args[$key . '[login_with_email].checked'] = isset($provider['login_with_email']) ? 1 : 0;

			} else
			{
				$args[$key . '[enabled].checked'] = 0;
				$args[$key . '[client_id].value'] = '';
				$args[$key . '[client_secret].value'] = '';
			}
		}

		$template = 'socialconnect/admin.html';
		$page_title = __('Social Connect providers');
		return new TemplaterCallResponse($template, $args, $page_title);
	}

	public function Save(Application $app, ServerRequestInterface $request)
	{
		if (!gpc::IsSubmit($request))
			return RedirectResponse::httpRedirect('/socialconnect/admin', "No token provided", true);

		$providers_mapping = $app['socialconnect.providers_mapping'];
		$opauth_config = $app['socialconnect.opauth_config']['Strategy'];

		$new_providers = [];
		foreach ($providers_mapping as $provider_name => $info)
		{
			$key = $info['url'];
			$client_id_key = $info['client_id'];
			$client_secret_key = $info['client_secret'];

			$request_data = gpc::getvar($request, $key);
			$existing_config = isset($opauth_config[$provider_name]) ? $opauth_config[$provider_name] : [];

			if (!empty($request_data['enabled']) && isset($request_data['client_id']))
			{
				$new_providers[$provider_name] = [];
				$new_providers[$provider_name][$client_id_key] = $request_data['client_id'];

				$secret = $request_data['client_secret'];
				if (isset($existing_config[$client_secret_key]) && $this->ObscureSecret($existing_config[$client_secret_key]) === $secret)
					$new_providers[$provider_name][$client_secret_key] = $existing_config[$client_secret_key];
				else
					$new_providers[$provider_name][$client_secret_key] = $secret;


                if (isset($info['login_with_email']) && isset($request_data['login_with_email']))
                {
                    $new_providers[$provider_name]['login_with_email'] = $request_data['login_with_email'];
                }
            }
		}

		/** @var Config $config_file */
		$config_file = $app['socialconnect.config'];
		$config_file->Set('providers', $new_providers);
		$config_file->Save();

		$opauth_config = $opauth_config = $app['socialconnect.opauth_config'];
		$opauth_config['Strategy'] = $new_providers;

		unset($app['socialconnect.opauth_config']);
		$app['socialconnect.opauth_config'] = $opauth_config;

		return RedirectResponse::httpRedirect('/socialconnect/admin', __("Accounts saved"));
	}

	protected function ObscureSecret($secret_str)
	{
		if (strlen($secret_str) > 10)
			return substr($secret_str, 0, 4) . '*****' . substr($secret_str, -4);
		else
			return '*********';
	}
}
