<?php
namespace Claromentis\SocialConnect\Controller;

use Claromentis\Core\Application;
use Claromentis\Core\Http\gpc;
use Claromentis\Core\Http\RedirectResponse;
use Claromentis\Core\Http\TemplaterCallResponse;
use Claromentis\SocialConnect\AccountsRepository;
use Claromentis\SocialConnect\Exception\LinkedOtherUserException;
use Claromentis\SocialConnect\SocialAccount;
use Psr\Http\Message\ServerRequestInterface;
use Symfony\Component\HttpFoundation\Response;

/**
 * Controller that handles connecting new accounts and disconnecting
 *
 * @author Alexander Polyanskikh
 */
class ConnectController
{
	public function Connect(Application $app, ServerRequestInterface $request, $provider)
	{
		$session = $app->session;
		$s_data = $session->get('socialconnect', []);
		if (!isset($s_data['result']))
		{
			$session->set('socialconnect', [
				'continue' => gpc::getRequestPath($request)
			]);

			return RedirectResponse::httpRedirect('/socialconnect/' . strtolower($provider) . '?popup=1');
		}

		/** @var AccountsRepository $repo */
		$repo = $app['socialconnect.accounts'];

		$result = $s_data['result'];
		$session->remove('socialconnect');

		if (!$result['success'])
		{
			$args = [];
			$args['is_error.visible'] = 1;
			$args['error_text.body'] = $result['message'];

			$args['retry_link.href'] = '/socialconnect/_connect/' . $result['provider'];

			$template = 'socialconnect/connect.html';
			return new TemplaterCallResponse($template, $args);
		}

		$provider = $result['provider'];
		//$userinfo = $info['info'];
		$user_id_str = $result['uid'];

		$args = [];
		try
		{
			$account = SocialAccount::CreateNew($app->security->GetUserId(), $provider, $user_id_str);

			$repo->Add($account);
			$args['is_success.visible'] = 1;
		} catch (LinkedOtherUserException $e)
		{
			$args['is_success.visible'] = 0;
			$args['is_error.visible'] = 1;
			$args['error_text.body'] = $e->getMessage();
		}

		$args['provider_name.json'] = $provider;
		$template = 'socialconnect/connect.html';
		return new TemplaterCallResponse($template, $args);
	}

	public function Disconnect(Application $app, ServerRequestInterface $request, $provider)
	{
		gpc::CheckToken($request);

		/** @var AccountsRepository $repo */
		$repo = $app['socialconnect.accounts'];

		$accounts = $repo->GetForUser($app->security->GetUserId(), $provider);

		if (empty($accounts))
		{
			return new Response("This account type is not connected, please reload the page", Response::HTTP_PRECONDITION_FAILED);
		}

		foreach ($accounts as $acc)
		{
			$repo->Delete($acc);
		}

		return new Response('', Response::HTTP_NO_CONTENT);
	}
}