<?php

namespace Claromentis\SocialConnect;

use Claromentis\People\Event\DeleteUserEvent;
use Claromentis\People\Event\PeopleEventType;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class EventSubscriber implements EventSubscriberInterface
{
	/** @var AccountsRepository */
	private $accounts_repository;

	public function __construct(AccountsRepository $accounts_repository)
	{
		$this->accounts_repository = $accounts_repository;
	}

	/** @inheritDoc */
	public static function getSubscribedEvents()
	{
		return [
			PeopleEventType::DELETE_USER => 'UserDeleted'
		];
	}

	/**
	 * Deletes Social Accounts for the deleted User.
	 *
	 * @param DeleteUserEvent $event
	 */
	public function UserDeleted(DeleteUserEvent $event)
	{
		foreach ($this->accounts_repository->GetForUser($event->GetUserId()) as $social_account)
		{
			$this->accounts_repository->Delete($social_account);
		}
	}
}
