<?php
namespace Claromentis\SocialConnect;

use ObjectsStorage;

/**
 * @property-read int id
 * @property-read int user_id
 * @property-read string provider
 * @property-read string remote_uid
 * @property-read string data
 *
 * @author Alexander Polyanskikh
 */
class SocialAccount extends \ActiveRecord
{
	/**
	 * Describes the database table structure. Usually looks like this:
	 *
	 *    $storage->MapDbTable($this, 'table_name', 'id'); // table name and optional identity column
	 *
	 *    $storage->MapDbColumn($this, 'id', ObjectsStorage::T_AUTOINCREMENT);
	 *    $storage->MapDbColumn($this, 'name', ObjectsStorage::T_STRING, 100);
	 *    $storage->MapDbColumn($this, 'description', ObjectsStorage::T_CLOB);
	 *    $storage->MapDbColumn($this, 'comment', ObjectsStorage::T_STRING);
	 *
	 *  // optionally enable caching. See ObjectsStorage::SetCacheMode for details
	 *  $storage->SetCacheMode($this, ClaCache::C_SHARED);
	 *
	 * @param ObjectsStorage $storage
	 *
	 * @return mixed
	 */
	public function InitDbMapping(ObjectsStorage $storage)
	{
		$storage->MapDbTable($this, 'social_accounts', 'id'); // table name and optional identity column

		$storage->MapDbColumn($this, 'id', ObjectsStorage::T_AUTOINCREMENT);
		$storage->MapDbColumn($this, 'user_id', ObjectsStorage::T_INT);
		$storage->MapDbColumn($this, 'provider', ObjectsStorage::T_STRING, 255);
		$storage->MapDbColumn($this, 'remote_uid', ObjectsStorage::T_STRING, 1024);
		$storage->MapDbColumn($this, 'data', ObjectsStorage::T_CLOB);

		// optionally enable caching. See ObjectsStorage::SetCacheMode for details
		//$storage->SetCacheMode($this, ClaCache::C_SHARED);
	}

	/**
	 *
	 * @param int $user_id
	 * @param string $provider
	 * @param string $remote_uid
	 *
	 * @return SocialAccount
	 */
	static public function CreateNew($user_id, $provider, $remote_uid)
	{
		$account = new static();
		$account->LoadFromArray([
			                        'user_id' => $user_id,
			                        'provider' => $provider,
			                        'remote_uid' => $remote_uid,
		                        ]);
		return $account;
	}
}
