<?php
namespace Claromentis\SocialConnect\UI;

use Claromentis\Core\Application;
use Claromentis\Core\Templater\Plugin\TemplaterComponentTmpl;
use Claromentis\SocialConnect\AccountsRepository;

/**
 * UI component to display list of connected social accounts and connect/disconnect them
 *
 * @author Alexander Polyanskikh
 */
class ConnectedAccounts extends TemplaterComponentTmpl
{
	public function Show($attributes, Application $app)
	{
		$args = [];

		$social_config = $app['socialconnect.opauth_config'];
		/** @var AccountsRepository $repo */
		$repo = $app['socialconnect.accounts'];
		$providers = $social_config['Strategy'];

		if (empty($providers))
			return '';

		$user_id = $app->security->GetUserId();


		// connected accounts
		$args['connected_accounts.datasrc'] = [];
		$accounts = $repo->GetForUser($user_id);

		$accounts_by_provider = [];
		foreach ($accounts as $acc)
		{
			$accounts_by_provider[$acc->provider] = $acc;
		}

		foreach ($providers as $provider_name => $provider_info)
		{
			if (!isset($provider_info['enabled']) || $provider_info['enabled'])
			{
				$arr = [
					'account_name.body' => $provider_name,
					'provider_group.data-provider' => $provider_name,
				];

				if (isset($accounts_by_provider[$provider_name])) // already connected
				{
					$arr['connected.style'] = '';
				} else
				{
					$arr['not_connected.style'] = '';
				}

				$args['connected_accounts.datasrc'][] = $arr;
			}
		}

		$template = 'socialconnect/connected_accounts.html';
		return $this->CallTemplater($template, $args);
	}
}