<?php
namespace Claromentis\SocialConnect\UI;

use Claromentis\Core\Application;
use Claromentis\Core\Templater\Plugin\TemplaterComponentTmpl;

/**
 * Displays login button (primarily on the login page)
 */
class LoginButtons extends TemplaterComponentTmpl
{
	public function Show($attributes, Application $app)
	{
		$args = [];

		$social_config = $app['socialconnect.opauth_config'];
		$providers = $social_config['Strategy'];

		if (empty($providers))
			return '';

		$requested_url = isset($attributes['requested_url']) && $attributes['requested_url'] != '/login' ? $attributes['requested_url'] : '/';

		$args['page_url'] = cla_htmlsafe(urlencode($requested_url));

		foreach ($providers as $provider_name => $provider_info)
		{
			if (!isset($provider_info['enabled']) || $provider_info['enabled'])
			{
				$args["provider_$provider_name.visible"] = 1;
			}
		}

		$template = 'socialconnect/login_buttons.html';
		return $this->CallTemplater($template, $args);
	}
}