<?php
namespace Claromentis\ThankYou\Tags\Tests\Unit;

$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"] ?: array()) + array("_43a146d58dfac222116b" . "5b4981a5c26e" => base64_decode("U2V0Q3J" . "lYXRlZE" . "RhdGU="), "_7cadbf56127d56a8c" . "b887a77494a04ff" => base64_decode("dGFnX" . "2RlbG" . "V0ZQ=" . "="), "_2a2bab48c272" . "fd6ef76276e2b" . "a1fe676" => base64_decode("RGVsZXRlVGFnZ2FibGVUYWdnaW5ncw=" . "="), "_ddc76205e17a3a43b11e14f1d36fd1" . "90" => base64_decode("dGFnX2" . "NyZWF0" . "ZQ=="), "_ab628f2cf3dadf271fe688e0e104bf" . "50" => base64_decode("R2V0VGFnc1RhZ2" . "dpbmdUb3RhbHNG" . "cm9tSWRz"), "_967c308a876eece3c9e3745a" . "77ec14be" => base64_decode("QSBOYW1" . "lIQ=="), "_ab069d63a145487" . "03bf1b2ab876faea" . "1" => base64_decode("RGVs" . "ZXRl"), "_4992d7d04709baa" . "aeca665a640c3521" . "a" => base64_decode("R2V0" . "VGFn" . "cw=="), "_31767d7ad58e706dbf47" . "b7a51a0fe6c4" => base64_decode("Y29" . "1bn" . "Q="), "_19913783e7274f" . "f965f610467b3c8" . "3f4" => base64_decode("R2V0V" . "G90YW" . "xUYWd" . "z"), "_2e8591955d04ad52b2282f92bd066" . "8d7" => base64_decode("U2F2ZV" . "RhZ2dp" . "bmc="), "_ed39ee8" . "6ba57451" . "6265a9a7" . "689060bd" . "0" => base64_decode("Q2FuRGVsZXRlVG" . "Fn"), "_2c6d2c71538b29108c0f05869" . "7739701" => base64_decode("U2V0TW9kaWZpZWRCe" . "Q=="), "_af7aa146d9ef32f0" . "d3b4ff0eb5337856" => base64_decode("dGFnX2V" . "kaXQ="), "_188006963ee2fe1ce10fd14db928a3" . "6f" => base64_decode("U2V0T" . "W9kaW" . "ZpZWR" . "EYXRl"), "_3ef054c2ede" . "baf39b275c9a" . "26b2d92a4" => base64_decode("R2V0Rmls" . "dGVyZWRU" . "YWdz"), "_bbe0c56d4a25e" . "a2145ec20d5672" . "af2a5" => base64_decode("U3R" . "vcm" . "U="), "_1d20a76d22a0a0579f5fd019a3a882" . "4f" => base64_decode("Q3" . "Jl" . "YX" . "Rl"), "_3b5993fd14b595d9ca1c03c8b" . "d00399b" => base64_decode("R2V0VGFnZ2FibGVzVGFnc" . "w=="), "_fa7db904b806745427ca8dcfd" . "36f2580" => base64_decode("R2V" . "0SW" . "Q="), "_bc592d0481626c005c8b859825fef90" . "1" => base64_decode("U2F2ZQ" . "=="), "_f64b859465148f3c9549" . "ee0cdacaaf84" => base64_decode("R2V0VGFnc" . "1RhZ2dpbm" . "dUb3RhbHM" . "="), "_8b46749f777ee158f4a7d49e0ce3c" . "571" => base64_decode("U2V0Q3JlYX" . "RlZEJ5"), "_798ecc8216dcacb7c" . "d2d2788fa03f96f" => base64_decode("aW5" . "0"));
use Claromentis\Core\Audit\Audit;
use Claromentis\Core\Repository\Exception\StorageException;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\People\Entity\User;
use Claromentis\People\Repository\UserRepository;
use Claromentis\ThankYou\Tags\Api;
use Claromentis\ThankYou\Tags\Exceptions\TagForbiddenException;
use Claromentis\ThankYou\Tags\Exceptions\TagNotFoundException;
use Claromentis\ThankYou\Tags\Tag;
use Claromentis\ThankYou\Tags\TagAcl;
use Claromentis\ThankYou\Tags\TagFactory;
use Claromentis\ThankYou\Tags\TagRepository;
use Claromentis\ThankYou\Tags\Validator;
use Date;
use InvalidArgumentException;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
class ApiTest extends TestCase
{
    
    
    
    
    private $api;
    
    
    
    
    private $audit_mock;
    
    
    
    
    private $security_context_mock;
    
    
    
    
    private $tag_acl_mock;
    
    
    
    
    private $tag_factory_mock;
    
    
    
    
    private $tag_mock;
    
    
    
    
    private $tag_repository_mock;
    
    
    
    
    private $user_mock;
    
    
    
    
    private $validator_mock;
    
    
    
    
    private $user_repository_mock;
    public function SetUp()
    {
        $this->audit_mock = $this->createMock(Audit::class);
        $this->tag_acl_mock = $this->createMock(TagAcl::class);
        $this->tag_factory_mock = $this->createMock(TagFactory::class);
        $this->tag_repository_mock = $this->createMock(TagRepository::class);
        $this->tag_mock = $this->createMock(Tag::class);
        $this->user_mock = $this->createMock(User::class);
        $this->security_context_mock = $this->createMock(SecurityContext::class);
        $this->validator_mock = $this->createMock(Validator::class);
        $this->user_repository_mock = $this->createMock(UserRepository::class);
        $this->api = new Api($this->audit_mock, $this->tag_repository_mock, $this->tag_factory_mock, $this->tag_acl_mock, $this->validator_mock, $this->user_repository_mock);
    }
    public function testGetTagSuccessful()
    {
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_4992d7d04709baaaeca665a640" . "c3521a"])->willReturn([1 => $this->tag_mock]);
        $this->assertSame($this->tag_mock, $this->api->GetTag(1));
    }
    public function testGetTagNotFound()
    {
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_4992d7d04709baaaeca665a" . "640c3521a"])->willReturn([]);
        $this->expectException(TagNotFoundException::class);
        $this->api->GetTag(1);
    }
    public function testGetTagsSuccessful()
    {
        $_fc6ba419dda510bd33c18bf745f5a159 = [$this->tag_mock];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_3ef054c2ed" . "ebaf39b275c" . "9a26b2d92a4"])->willReturn($_fc6ba419dda510bd33c18bf745f5a159);
        $this->assertSame($_fc6ba419dda510bd33c18bf745f5a159, $this->api->GetTags());
    }
    public function testGetTagsByIdSuccessful()
    {
        $_57d862d7953b79543efc193e28bfe521 = [629 => $this->tag_mock];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_4992d7d04709baaaeca66" . "5a640c3521a"])->willReturn($_57d862d7953b79543efc193e28bfe521);
        $this->assertSame($_57d862d7953b79543efc193e28bfe521, $this->api->GetTagsById([629]));
    }
    public function testGetTaggableTagsSuccessfulTagsFound()
    {
        $_9f446f32674875fcd432d0f725dc0444 = [1 => $this->tag_mock];
        $_41b38fb02e560a02763577d91c477d58 = [1 => $_9f446f32674875fcd432d0f725dc0444];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_3b5993fd14b595d9ca1c03c8bd00399" . "b"])->willReturn($_41b38fb02e560a02763577d91c477d58);
        $this->assertSame($_9f446f32674875fcd432d0f725dc0444, $this->api->GetTaggableTags(1, 1337));
    }
    public function testGetTaggableTagsSuccessfulNoTags()
    {
        $_9f446f32674875fcd432d0f725dc0444 = [];
        $_41b38fb02e560a02763577d91c477d58 = [1 => $_9f446f32674875fcd432d0f725dc0444];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_3b5993fd1" . "4b595d9ca1" . "c03c8bd003" . "99b"])->willReturn($_41b38fb02e560a02763577d91c477d58);
        $this->assertSame($_9f446f32674875fcd432d0f725dc0444, $this->api->GetTaggableTags(1, 1337));
    }
    public function testGetTaggablesTagsSuccessful()
    {
        $_41b38fb02e560a02763577d91c477d58 = [1 => [1 => $this->tag_mock]];
        $_9f446f32674875fcd432d0f725dc0444 = $_41b38fb02e560a02763577d91c477d58;
        $_9f446f32674875fcd432d0f725dc0444[2] = [];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_3b5993fd14b595d" . "9ca1c03c8bd00399" . "b"])->willReturn($_9f446f32674875fcd432d0f725dc0444);
        $this->assertSame($_9f446f32674875fcd432d0f725dc0444, $this->api->GetTaggablesTags([1, 2], 1337));
    }
    public function testGetTotalTagsSuccessful()
    {
        $_9f446f32674875fcd432d0f725dc0444 = 3;
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_19913783" . "e7274ff96" . "5f610467b" . "3c83f4"])->willReturn($_9f446f32674875fcd432d0f725dc0444);
        $this->assertSame($_9f446f32674875fcd432d0f725dc0444, $this->api->GetTotalTags());
    }
    public function testGetTagsTaggingTotalsSuccessful()
    {
        $_9f446f32674875fcd432d0f725dc0444 = [1 => 56, 2 => 0, 3 => 9];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_f64b859465148f3c9549" . "ee0cdacaaf84"])->willReturn($_9f446f32674875fcd432d0f725dc0444);
        $this->assertSame($_9f446f32674875fcd432d0f725dc0444, $this->api->GetTagsTaggingTotals());
    }
    public function testGetTagsTaggingTotalsFromIdsSuccessful()
    {
        $_9f446f32674875fcd432d0f725dc0444 = [1 => 56, 2 => 0, 3 => 9];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_ab628f2cf3dadf271fe688e0e1" . "04bf50"])->willReturn($_9f446f32674875fcd432d0f725dc0444);
        $this->assertSame($_9f446f32674875fcd432d0f725dc0444, $this->api->GetTagsTaggingTotalsFromIds([1, 2, 3]));
    }
    public function testCreateSuccessful()
    {
        $_8dabb06efc95df4cff7c4afe91857b53 = $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_967c308a876ee" . "ce3c9e3745a77e" . "c14be"];
        $this->tag_factory_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_1d20a76d22a0" . "a0579f5fd019a" . "3a8824f"])->with($_8dabb06efc95df4cff7c4afe91857b53)->willReturn($this->tag_mock);
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_8b46749f" . "777ee158f" . "4a7d49e0c" . "e3c571"])->with($this->user_mock);
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_43a146d58dfac222116b5b4981a5c26" . "e"])->with($this->callback(function ($_2cf88b59cb09eaa06ee558d90cff8e4e) {
            return $_2cf88b59cb09eaa06ee558d90cff8e4e instanceof Date;
        }));
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_2c6d2c71538b29" . "108c0f058697739" . "701"])->with($this->user_mock);
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_188006963ee2fe1ce10fd14db928a3" . "6f"])->with($this->callback(function ($_2cf88b59cb09eaa06ee558d90cff8e4e) {
            return $_2cf88b59cb09eaa06ee558d90cff8e4e instanceof Date;
        }));
        $this->assertSame($this->tag_mock, $this->api->Create($this->user_mock, $_8dabb06efc95df4cff7c4afe91857b53));
    }
    public function testSaveSuccessfulNew()
    {
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_bc592d0481626c0" . "05c8b859825fef90" . "1"])->with($this->tag_mock)->willReturnCallback(function ($_402209aba575baaba313d7e099faee2a) {
            
            
            
            
            $_402209aba575baaba313d7e099faee2a->method($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_fa7db904b806745427ca8dcfd36f" . "2580"])->willReturn(1);
        });
        $this->audit_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_bbe0c56d4a25ea2145ec20d567" . "2af2a5"])->with(Audit::AUDIT_SUCCESS, $this->anything(), $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_ddc76205e17a3a43b11e14f1d36fd" . "190"]);
        $this->api->Save($this->tag_mock);
    }
    public function testSaveSuccessfulEdit()
    {
        $this->tag_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_fa7db904b806" . "745427ca8dcfd" . "36f2580"])->willReturn(1);
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_bc592d048162" . "6c005c8b85982" . "5fef901"])->with($this->tag_mock);
        $this->audit_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_bbe0c56d4a25ea" . "2145ec20d5672af" . "2a5"])->with(Audit::AUDIT_SUCCESS, $this->anything(), $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_af7aa146d9ef32f0d3b4ff0eb53" . "37856"]);
        $this->api->Save($this->tag_mock);
    }
    public function testDeleteSuccessful()
    {
        $_a6907375c5b6ba7c8d8a5d88a84880fd = 1;
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_4992d7d04709baaaeca665a640c3" . "521a"])->willReturn([$_a6907375c5b6ba7c8d8a5d88a84880fd => $this->tag_mock]);
        $this->tag_acl_mock->expects($this->any())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_ed39ee86ba574516265a9a76890" . "60bd0"])->with($this->security_context_mock)->willReturn(true);
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_ab069d63a14548703bf1b2ab" . "876faea1"])->with($_a6907375c5b6ba7c8d8a5d88a84880fd);
        $this->audit_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_bbe0c56d4a25ea214" . "5ec20d5672af2a5"])->with(Audit::AUDIT_SUCCESS, $this->anything(), $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_7cadbf56127d56a8cb887a77494" . "a04ff"], $_a6907375c5b6ba7c8d8a5d88a84880fd);
        $this->api->Delete($_a6907375c5b6ba7c8d8a5d88a84880fd, $this->security_context_mock);
    }
    public function testDeleteTagNotFound()
    {
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_4992d7d04709baaaeca" . "665a640c3521a"])->willReturn([]);
        $this->tag_acl_mock->expects($this->any())->method($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_ed39ee86ba574516" . "265a9a7689060bd0"])->with($this->security_context_mock)->willReturn(true);
        $this->expectException(TagNotFoundException::class);
        $this->api->Delete(1, $this->security_context_mock);
    }
    public function testDeleteForbidden()
    {
        $this->tag_acl_mock->expects($this->any())->method($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_ed39ee86ba" . "574516265a9" . "a7689060bd0"])->with($this->security_context_mock)->willReturn(false);
        $this->expectException(TagForbiddenException::class);
        $this->api->Delete(1, $this->security_context_mock);
    }
    public function testDeleteStorageException()
    {
        $_a6907375c5b6ba7c8d8a5d88a84880fd = 1;
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_4992d7d04709baaaeca665a640c" . "3521a"])->willReturn([$_a6907375c5b6ba7c8d8a5d88a84880fd => $this->tag_mock]);
        $this->tag_acl_mock->expects($this->any())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_ed39ee86ba57451" . "6265a9a7689060bd" . "0"])->with($this->security_context_mock)->willReturn(true);
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_ab069d63a14548703bf1b2ab" . "876faea1"])->willThrowException(new StorageException());
        $this->expectException(StorageException::class);
        $this->api->Delete($_a6907375c5b6ba7c8d8a5d88a84880fd, $this->security_context_mock);
    }
    public function testAddTaggingSuccessful()
    {
        $_567731785602759f48bc5f9970e7aa0d = 2;
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_fa7db904b80674" . "5427ca8dcfd36f2" . "580"])->willReturn(1);
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_2e8591955d0" . "4ad52b2282f9" . "2bd0668d7"])->willReturn($_567731785602759f48bc5f9970e7aa0d);
        $this->assertSame($_567731785602759f48bc5f9970e7aa0d, $this->api->AddTagging(3, 4, $this->tag_mock));
    }
    public function testAddTaggingInvalidTag()
    {
        $this->expectException(InvalidArgumentException::class);
        $this->api->AddTagging(1, 2, $this->tag_mock);
    }
    public function testAddTaggingsSuccessful()
    {
        $_567731785602759f48bc5f9970e7aa0d = 1;
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_fa7db904b806745" . "427ca8dcfd36f258" . "0"])->willReturn(2);
        $_88c3371c12301c186c4ddcd33b877dbd = [$this->tag_mock];
        $this->tag_repository_mock->expects($this->exactly($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_31767d7ad58e706dbf47b7a51a0fe6" . "c4"]($_88c3371c12301c186c4ddcd33b877dbd)))->method($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_2e8591955d04ad52b22" . "82f92bd0668d7"])->willReturn($_567731785602759f48bc5f9970e7aa0d);
        $this->assertSame([$_567731785602759f48bc5f9970e7aa0d], $this->api->AddTaggings(1, 2, $_88c3371c12301c186c4ddcd33b877dbd));
    }
    public function testAddTaggingsInvalidTag()
    {
        $this->expectException(InvalidArgumentException::class);
        $this->api->AddTaggings(1, 2, [$this->tag_mock]);
    }
    public function testRemoveTaggingSuccessful()
    {
        $_582244c5cb7559ffae37fb0a1fb36415 = 1;
        $_41d37e63d4325e03a046cb9a94e03af5 = 2;
        $_a6907375c5b6ba7c8d8a5d88a84880fd = 3;
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_fa7db904b80" . "6745427ca8dc" . "fd36f2580"])->willReturn($_a6907375c5b6ba7c8d8a5d88a84880fd);
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_2a2bab48c272fd6e" . "f76276e2ba1fe676"])->with($_582244c5cb7559ffae37fb0a1fb36415, $_41d37e63d4325e03a046cb9a94e03af5, $_a6907375c5b6ba7c8d8a5d88a84880fd);
        $this->api->RemoveTagging($_582244c5cb7559ffae37fb0a1fb36415, $_41d37e63d4325e03a046cb9a94e03af5, $this->tag_mock);
    }
    public function testRemoveTaggingInvalidTag()
    {
        $this->expectException(InvalidArgumentException::class);
        $this->api->RemoveTagging(1, 2, $this->tag_mock);
    }
    public function testRemoveTaggingsSuccessful()
    {
        $_582244c5cb7559ffae37fb0a1fb36415 = 1;
        $_41d37e63d4325e03a046cb9a94e03af5 = 2;
        $_a6907375c5b6ba7c8d8a5d88a84880fd = 3;
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_fa7db904b806745427ca8dcfd3" . "6f2580"])->willReturn($_a6907375c5b6ba7c8d8a5d88a84880fd);
        $_88c3371c12301c186c4ddcd33b877dbd = [$this->tag_mock];
        $this->tag_repository_mock->expects($this->exactly($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_31767d7ad58e706" . "dbf47b7a51a0fe6c" . "4"]($_88c3371c12301c186c4ddcd33b877dbd)))->method($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_2a2bab48c272fd6" . "ef76276e2ba1fe67" . "6"])->with($_582244c5cb7559ffae37fb0a1fb36415, $_41d37e63d4325e03a046cb9a94e03af5, $this->isType($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_798ecc8216dcacb7cd2d" . "2788fa03f96f"]));
        $this->api->RemoveTaggings(1, 2, $_88c3371c12301c186c4ddcd33b877dbd);
    }
    public function testRemoveTaggingsInvalidTag()
    {
        $this->expectException(InvalidArgumentException::class);
        $this->api->RemoveTaggings(1, 2, [$this->tag_mock]);
    }
    public function testRemoveAllTaggableTaggingsSuccessful()
    {
        $_582244c5cb7559ffae37fb0a1fb36415 = 1;
        $_41d37e63d4325e03a046cb9a94e03af5 = 2;
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_2a2bab48" . "c272fd6ef" . "76276e2ba" . "1fe676"])->with($_582244c5cb7559ffae37fb0a1fb36415, $_41d37e63d4325e03a046cb9a94e03af5, null);
        $this->api->RemoveAllTaggableTaggings($_582244c5cb7559ffae37fb0a1fb36415, $_41d37e63d4325e03a046cb9a94e03af5);
    }
}