<?php
namespace Claromentis\ThankYou\Tags\Tests\Unit;

$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"] ?: array()) + array("_967c308a876eece3c9e3" . "745a77ec14be" => base64_decode("QSBOYW1lIQ=" . "="), "_f64b859465148f3" . "c9549ee0cdacaaf8" . "4" => base64_decode("R2V0VGFnc1RhZ2dpbmdUb3Rhb" . "HM="), "_1d20a76d22a0a05" . "79f5fd019a3a8824" . "f" => base64_decode("Q3JlYX" . "Rl"), "_ab069d63a14548703bf1b2a" . "b876faea1" => base64_decode("RGVsZXR" . "l"), "_798ecc8" . "216dcacb" . "7cd2d278" . "8fa03f96" . "f" => base64_decode("aW5" . "0"), "_43a146d58dfac222116b" . "5b4981a5c26e" => base64_decode("U2V0Q3JlYXRlZERhdGU" . "="), "_ab628f2cf" . "3dadf271fe" . "688e0e104b" . "f50" => base64_decode("R2V0VGFnc1RhZ2dp" . "bmdUb3RhbHNGcm9t" . "SWRz"), "_bbe0c56d4a25e" . "a2145ec20d5672" . "af2a5" => base64_decode("U3Rvcm" . "U="), "_2e8591955d04ad52b228" . "2f92bd0668d7" => base64_decode("U2F2ZVRhZ2dp" . "bmc="), "_2c6d2c71538b" . "29108c0f05869" . "7739701" => base64_decode("U2V0TW9ka" . "WZpZWRCeQ" . "=="), "_ed39ee86ba574516265a9" . "a7689060bd0" => base64_decode("Q2FuRGVsZXRlVGF" . "n"), "_ddc76205e17a3a43b11e14f1d36f" . "d190" => base64_decode("dGFnX2NyZWF0" . "ZQ=="), "_8b46749f777ee15" . "8f4a7d49e0ce3c57" . "1" => base64_decode("U2V0Q3JlYXRlZ" . "EJ5"), "_bc592d04816" . "26c005c8b859" . "825fef901" => base64_decode("U2" . "F2" . "ZQ" . "=="), "_188006963ee2f" . "e1ce10fd14db92" . "8a36f" => base64_decode("U2V0TW9kaWZpZ" . "WREYXRl"), "_4992d7d04709baaaeca665" . "a640c3521a" => base64_decode("R2V" . "0VG" . "Fnc" . "w=="), "_3b5993fd14b595d9c" . "a1c03c8bd00399b" => base64_decode("R2V0VGFnZ2" . "FibGVzVGFn" . "cw=="), "_19913783e7274ff965f610467" . "b3c83f4" => base64_decode("R2V0VG" . "90YWxU" . "YWdz"), "_31767d7ad" . "58e706dbf4" . "7b7a51a0fe" . "6c4" => base64_decode("Y291bnQ" . "="), "_fa7db904b806745427ca8d" . "cfd36f2580" => base64_decode("R2V0S" . "WQ="), "_2a2bab48" . "c272fd6ef" . "76276e2ba" . "1fe676" => base64_decode("RGVsZXRlVGFnZ2FibGVUYWdnaW5ncw" . "=="), "_af7aa146d9ef32f0d3b4ff0eb533" . "7856" => base64_decode("dGFnX2" . "VkaXQ="), "_3ef054c2edebaf39b275c9a26b2d92a" . "4" => base64_decode("R2V0Rmls" . "dGVyZWRU" . "YWdz"), "_7cadbf56127d56a8cb887a77494a" . "04ff" => base64_decode("dGFnX2RlbGV0ZQ" . "=="));
use Claromentis\Core\Audit\Audit;
use Claromentis\Core\Repository\Exception\StorageException;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\People\Entity\User;
use Claromentis\People\Repository\UserRepository;
use Claromentis\ThankYou\Tags\Api;
use Claromentis\ThankYou\Tags\Exceptions\TagForbiddenException;
use Claromentis\ThankYou\Tags\Exceptions\TagNotFoundException;
use Claromentis\ThankYou\Tags\Tag;
use Claromentis\ThankYou\Tags\TagAcl;
use Claromentis\ThankYou\Tags\TagFactory;
use Claromentis\ThankYou\Tags\TagRepository;
use Claromentis\ThankYou\Tags\Validator;
use Date;
use InvalidArgumentException;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
class ApiTest extends TestCase
{
    
    
    
    
    private $api;
    
    
    
    
    private $audit_mock;
    
    
    
    
    private $security_context_mock;
    
    
    
    
    private $tag_acl_mock;
    
    
    
    
    private $tag_factory_mock;
    
    
    
    
    private $tag_mock;
    
    
    
    
    private $tag_repository_mock;
    
    
    
    
    private $user_mock;
    
    
    
    
    private $validator_mock;
    
    
    
    
    private $user_repository_mock;
    public function SetUp()
    {
        $this->audit_mock = $this->createMock(Audit::class);
        $this->tag_acl_mock = $this->createMock(TagAcl::class);
        $this->tag_factory_mock = $this->createMock(TagFactory::class);
        $this->tag_repository_mock = $this->createMock(TagRepository::class);
        $this->tag_mock = $this->createMock(Tag::class);
        $this->user_mock = $this->createMock(User::class);
        $this->security_context_mock = $this->createMock(SecurityContext::class);
        $this->validator_mock = $this->createMock(Validator::class);
        $this->user_repository_mock = $this->createMock(UserRepository::class);
        $this->api = new Api($this->audit_mock, $this->tag_repository_mock, $this->tag_factory_mock, $this->tag_acl_mock, $this->validator_mock, $this->user_repository_mock);
    }
    public function testGetTagSuccessful()
    {
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_4992d7d" . "04709baa" . "aeca665a" . "640c3521" . "a"])->willReturn([1 => $this->tag_mock]);
        $this->assertSame($this->tag_mock, $this->api->GetTag(1));
    }
    public function testGetTagNotFound()
    {
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_4992d7d04709ba" . "aaeca665a640c35" . "21a"])->willReturn([]);
        $this->expectException(TagNotFoundException::class);
        $this->api->GetTag(1);
    }
    public function testGetTagsSuccessful()
    {
        $_fc6ba419dda510bd33c18bf745f5a159 = [$this->tag_mock];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_3ef054c2edebaf39b275c9a26b" . "2d92a4"])->willReturn($_fc6ba419dda510bd33c18bf745f5a159);
        $this->assertSame($_fc6ba419dda510bd33c18bf745f5a159, $this->api->GetTags());
    }
    public function testGetTagsByIdSuccessful()
    {
        $_57d862d7953b79543efc193e28bfe521 = [629 => $this->tag_mock];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_4992d7d04709baaaeca665a6" . "40c3521a"])->willReturn($_57d862d7953b79543efc193e28bfe521);
        $this->assertSame($_57d862d7953b79543efc193e28bfe521, $this->api->GetTagsById([629]));
    }
    public function testGetTaggableTagsSuccessfulTagsFound()
    {
        $_9f446f32674875fcd432d0f725dc0444 = [1 => $this->tag_mock];
        $_41b38fb02e560a02763577d91c477d58 = [1 => $_9f446f32674875fcd432d0f725dc0444];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_3b5993fd14b595d9ca1c" . "03c8bd00399b"])->willReturn($_41b38fb02e560a02763577d91c477d58);
        $this->assertSame($_9f446f32674875fcd432d0f725dc0444, $this->api->GetTaggableTags(1, 1337));
    }
    public function testGetTaggableTagsSuccessfulNoTags()
    {
        $_9f446f32674875fcd432d0f725dc0444 = [];
        $_41b38fb02e560a02763577d91c477d58 = [1 => $_9f446f32674875fcd432d0f725dc0444];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_3b5993fd14" . "b595d9ca1c0" . "3c8bd00399b"])->willReturn($_41b38fb02e560a02763577d91c477d58);
        $this->assertSame($_9f446f32674875fcd432d0f725dc0444, $this->api->GetTaggableTags(1, 1337));
    }
    public function testGetTaggablesTagsSuccessful()
    {
        $_41b38fb02e560a02763577d91c477d58 = [1 => [1 => $this->tag_mock]];
        $_9f446f32674875fcd432d0f725dc0444 = $_41b38fb02e560a02763577d91c477d58;
        $_9f446f32674875fcd432d0f725dc0444[2] = [];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_3b5993fd1" . "4b595d9ca1" . "c03c8bd003" . "99b"])->willReturn($_9f446f32674875fcd432d0f725dc0444);
        $this->assertSame($_9f446f32674875fcd432d0f725dc0444, $this->api->GetTaggablesTags([1, 2], 1337));
    }
    public function testGetTotalTagsSuccessful()
    {
        $_9f446f32674875fcd432d0f725dc0444 = 3;
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_19913783e7274ff965f610467b3c8" . "3f4"])->willReturn($_9f446f32674875fcd432d0f725dc0444);
        $this->assertSame($_9f446f32674875fcd432d0f725dc0444, $this->api->GetTotalTags());
    }
    public function testGetTagsTaggingTotalsSuccessful()
    {
        $_9f446f32674875fcd432d0f725dc0444 = [1 => 56, 2 => 0, 3 => 9];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_f64b859465148f3c9549e" . "e0cdacaaf84"])->willReturn($_9f446f32674875fcd432d0f725dc0444);
        $this->assertSame($_9f446f32674875fcd432d0f725dc0444, $this->api->GetTagsTaggingTotals());
    }
    public function testGetTagsTaggingTotalsFromIdsSuccessful()
    {
        $_9f446f32674875fcd432d0f725dc0444 = [1 => 56, 2 => 0, 3 => 9];
        $this->tag_repository_mock->method($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_ab628f2cf" . "3dadf271fe" . "688e0e104b" . "f50"])->willReturn($_9f446f32674875fcd432d0f725dc0444);
        $this->assertSame($_9f446f32674875fcd432d0f725dc0444, $this->api->GetTagsTaggingTotalsFromIds([1, 2, 3]));
    }
    public function testCreateSuccessful()
    {
        $_8dabb06efc95df4cff7c4afe91857b53 = $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_967c308a876eece3c9e37" . "45a77ec14be"];
        $this->tag_factory_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_1d20a76d22a0a0579f" . "5fd019a3a8824f"])->with($_8dabb06efc95df4cff7c4afe91857b53)->willReturn($this->tag_mock);
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_8b46749f7" . "77ee158f4a" . "7d49e0ce3c" . "571"])->with($this->user_mock);
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_43a146d58dfac22211" . "6b5b4981a5c26e"])->with($this->callback(function ($_2cf88b59cb09eaa06ee558d90cff8e4e) {
            return $_2cf88b59cb09eaa06ee558d90cff8e4e instanceof Date;
        }));
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_2c6d2c71538b29108c" . "0f058697739701"])->with($this->user_mock);
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_188006963ee2fe1ce10fd14d" . "b928a36f"])->with($this->callback(function ($_2cf88b59cb09eaa06ee558d90cff8e4e) {
            return $_2cf88b59cb09eaa06ee558d90cff8e4e instanceof Date;
        }));
        $this->assertSame($this->tag_mock, $this->api->Create($this->user_mock, $_8dabb06efc95df4cff7c4afe91857b53));
    }
    public function testSaveSuccessfulNew()
    {
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_bc592d0481626c005c8b" . "859825fef901"])->with($this->tag_mock)->willReturnCallback(function ($_402209aba575baaba313d7e099faee2a) {
            
            
            
            
            $_402209aba575baaba313d7e099faee2a->method($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_fa7db904b806745" . "427ca8dcfd36f258" . "0"])->willReturn(1);
        });
        $this->audit_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_bbe0c56" . "d4a25ea2" . "145ec20d" . "5672af2a" . "5"])->with(Audit::AUDIT_SUCCESS, $this->anything(), $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_ddc76205e17a3a43b11e1" . "4f1d36fd190"]);
        $this->api->Save($this->tag_mock);
    }
    public function testSaveSuccessfulEdit()
    {
        $this->tag_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_fa7db904b806745427c" . "a8dcfd36f2580"])->willReturn(1);
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_bc592d0481626c005c8b85" . "9825fef901"])->with($this->tag_mock);
        $this->audit_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_bbe0c56d" . "4a25ea214" . "5ec20d567" . "2af2a5"])->with(Audit::AUDIT_SUCCESS, $this->anything(), $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_af7aa146d" . "9ef32f0d3b" . "4ff0eb5337" . "856"]);
        $this->api->Save($this->tag_mock);
    }
    public function testDeleteSuccessful()
    {
        $_a6907375c5b6ba7c8d8a5d88a84880fd = 1;
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_4992d7d04709b" . "aaaeca665a640c" . "3521a"])->willReturn([$_a6907375c5b6ba7c8d8a5d88a84880fd => $this->tag_mock]);
        $this->tag_acl_mock->expects($this->any())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_ed39ee86ba574516265a9a768906" . "0bd0"])->with($this->security_context_mock)->willReturn(true);
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_ab069d63a14548703bf1b2a" . "b876faea1"])->with($_a6907375c5b6ba7c8d8a5d88a84880fd);
        $this->audit_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_bbe0c56d" . "4a25ea214" . "5ec20d567" . "2af2a5"])->with(Audit::AUDIT_SUCCESS, $this->anything(), $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_7cadbf56127d56a8cb887a77" . "494a04ff"], $_a6907375c5b6ba7c8d8a5d88a84880fd);
        $this->api->Delete($_a6907375c5b6ba7c8d8a5d88a84880fd, $this->security_context_mock);
    }
    public function testDeleteTagNotFound()
    {
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_4992d7d04709baaaeca665a640c3521" . "a"])->willReturn([]);
        $this->tag_acl_mock->expects($this->any())->method($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_ed39ee86ba57451" . "6265a9a7689060bd" . "0"])->with($this->security_context_mock)->willReturn(true);
        $this->expectException(TagNotFoundException::class);
        $this->api->Delete(1, $this->security_context_mock);
    }
    public function testDeleteForbidden()
    {
        $this->tag_acl_mock->expects($this->any())->method($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_ed39ee86ba574516265a9a768" . "9060bd0"])->with($this->security_context_mock)->willReturn(false);
        $this->expectException(TagForbiddenException::class);
        $this->api->Delete(1, $this->security_context_mock);
    }
    public function testDeleteStorageException()
    {
        $_a6907375c5b6ba7c8d8a5d88a84880fd = 1;
        $this->tag_repository_mock->method($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_4992d7d04709baaaeca" . "665a640c3521a"])->willReturn([$_a6907375c5b6ba7c8d8a5d88a84880fd => $this->tag_mock]);
        $this->tag_acl_mock->expects($this->any())->method($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_ed39ee86ba574516265a9a76890" . "60bd0"])->with($this->security_context_mock)->willReturn(true);
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_ab069d63a14" . "548703bf1b2a" . "b876faea1"])->willThrowException(new StorageException());
        $this->expectException(StorageException::class);
        $this->api->Delete($_a6907375c5b6ba7c8d8a5d88a84880fd, $this->security_context_mock);
    }
    public function testAddTaggingSuccessful()
    {
        $_567731785602759f48bc5f9970e7aa0d = 2;
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_fa7db904b8067" . "45427ca8dcfd36" . "f2580"])->willReturn(1);
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_2e8591955d04ad52b2282f92bd0668d" . "7"])->willReturn($_567731785602759f48bc5f9970e7aa0d);
        $this->assertSame($_567731785602759f48bc5f9970e7aa0d, $this->api->AddTagging(3, 4, $this->tag_mock));
    }
    public function testAddTaggingInvalidTag()
    {
        $this->expectException(InvalidArgumentException::class);
        $this->api->AddTagging(1, 2, $this->tag_mock);
    }
    public function testAddTaggingsSuccessful()
    {
        $_567731785602759f48bc5f9970e7aa0d = 1;
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_fa7db904b80" . "6745427ca8dc" . "fd36f2580"])->willReturn(2);
        $_88c3371c12301c186c4ddcd33b877dbd = [$this->tag_mock];
        $this->tag_repository_mock->expects($this->exactly($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_31767d7ad58e706dbf47b7a51a" . "0fe6c4"]($_88c3371c12301c186c4ddcd33b877dbd)))->method($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_2e85919" . "55d04ad5" . "2b2282f9" . "2bd0668d" . "7"])->willReturn($_567731785602759f48bc5f9970e7aa0d);
        $this->assertSame([$_567731785602759f48bc5f9970e7aa0d], $this->api->AddTaggings(1, 2, $_88c3371c12301c186c4ddcd33b877dbd));
    }
    public function testAddTaggingsInvalidTag()
    {
        $this->expectException(InvalidArgumentException::class);
        $this->api->AddTaggings(1, 2, [$this->tag_mock]);
    }
    public function testRemoveTaggingSuccessful()
    {
        $_582244c5cb7559ffae37fb0a1fb36415 = 1;
        $_41d37e63d4325e03a046cb9a94e03af5 = 2;
        $_a6907375c5b6ba7c8d8a5d88a84880fd = 3;
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_fa7db904b806745427ca8" . "dcfd36f2580"])->willReturn($_a6907375c5b6ba7c8d8a5d88a84880fd);
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_2a2bab48c272fd6" . "ef76276e2ba1fe67" . "6"])->with($_582244c5cb7559ffae37fb0a1fb36415, $_41d37e63d4325e03a046cb9a94e03af5, $_a6907375c5b6ba7c8d8a5d88a84880fd);
        $this->api->RemoveTagging($_582244c5cb7559ffae37fb0a1fb36415, $_41d37e63d4325e03a046cb9a94e03af5, $this->tag_mock);
    }
    public function testRemoveTaggingInvalidTag()
    {
        $this->expectException(InvalidArgumentException::class);
        $this->api->RemoveTagging(1, 2, $this->tag_mock);
    }
    public function testRemoveTaggingsSuccessful()
    {
        $_582244c5cb7559ffae37fb0a1fb36415 = 1;
        $_41d37e63d4325e03a046cb9a94e03af5 = 2;
        $_a6907375c5b6ba7c8d8a5d88a84880fd = 3;
        $this->tag_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_fa7db904b806745427ca8dcfd36f25" . "80"])->willReturn($_a6907375c5b6ba7c8d8a5d88a84880fd);
        $_88c3371c12301c186c4ddcd33b877dbd = [$this->tag_mock];
        $this->tag_repository_mock->expects($this->exactly($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_31767d7ad" . "58e706dbf4" . "7b7a51a0fe" . "6c4"]($_88c3371c12301c186c4ddcd33b877dbd)))->method($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_2a2bab48c272fd6ef76276e2b" . "a1fe676"])->with($_582244c5cb7559ffae37fb0a1fb36415, $_41d37e63d4325e03a046cb9a94e03af5, $this->isType($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_798ecc8216dcacb7c" . "d2d2788fa03f96f"]));
        $this->api->RemoveTaggings(1, 2, $_88c3371c12301c186c4ddcd33b877dbd);
    }
    public function testRemoveTaggingsInvalidTag()
    {
        $this->expectException(InvalidArgumentException::class);
        $this->api->RemoveTaggings(1, 2, [$this->tag_mock]);
    }
    public function testRemoveAllTaggableTaggingsSuccessful()
    {
        $_582244c5cb7559ffae37fb0a1fb36415 = 1;
        $_41d37e63d4325e03a046cb9a94e03af5 = 2;
        $this->tag_repository_mock->expects($this->once())->method($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_2a2bab48c272fd6ef" . "76276e2ba1fe676"])->with($_582244c5cb7559ffae37fb0a1fb36415, $_41d37e63d4325e03a046cb9a94e03af5, null);
        $this->api->RemoveAllTaggableTaggings($_582244c5cb7559ffae37fb0a1fb36415, $_41d37e63d4325e03a046cb9a94e03af5);
    }
}