% Script-File Aufruf_rec_formel3
%
% Aufruf: Aufruf_rec_formel3
%
% Berechnet die Sprung- und Impulsantwort ysigma_n 
% und ydelta_n eines digitalen Systems, welches 
% durch die Rekursionsformel 
%
%       y_n = y_{n-1}+25/36*y_{n-2}+ x_{n} -3/4*x_{n-1}.
%
% gegeben ist und vergleicht diese numerisch miteinander!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 09.03.2007/19.05.2018

% Eingangssignal bestimmen
% (hier: diskreter Impuls)

T = 1; Tend = 40;   % "Abtastintervall" und Endzeitpunkt            
nT = (0:T:Tend);    % Abtastzeitpunkte

impuls = zeros(size(nT));         % diskreter Impuls
impuls(1) = 1; sprung = nT>=0;    % diskreter Einheitssprung

% Aufruf der Rekursionsformel fr Impuls und Sprung
[ydelta_n] = rec_formel(impuls);
[ysigma_n] = rec_formel(sprung);

% Berechnung des Differenzsignals der Sprungantwort und der
% Summe der Impulsantwort
diffysigma = diff([0,ysigma_n]);
sumydelta = cumsum(ydelta_n);

% Gegenberstellung der Werte
[ysigma_n', sumydelta', ydelta_n', diffysigma']



