% Script AuswertungRausch.m
%
% Aufruf: AuswertungRausch
%
% Auswertung der Simulation mit dem Simulink-File
%
%       s_Rausch.slx
%
% Das Skript kann aufgerufen werden, nachdem der
% Workspace mit dem Kommanddo clear geleert, dann das
% Simulink-File s_Rausch.slx mit init_Rausch.m
% initilalisiert (Initialisierungsbutton drcken)
% und anschlieend gestartet wurde.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.01
% Datum: 19.11.2014/20.05.2018


% Darstellung der Signale
rsig0 = rsig0(:,2);
rsigbp = rsigbp(:,2);

figure
subplot(211)       % Rauschsignal plotten
plot(t,rsig0);
xlabel('Zeit/s')
ylabel('Ampl.')
grid

subplot(212)       % Bandpasssignal plotten
plot(t,rsigbp,'k');
xlabel('Zeit/s')
ylabel('Ampl.')
grid

% Kennwerte des Prozesses schtzen
EX = mean(rsig0)        % Schtzung Erwartungswert Rauschen
EY = mean(rsigbp)       % Schtzung Erwartungswert Bandpasssignal
VX = var(rsig0)         % Schtzung Varianz
VY = var(rsigbp)        % Schtzung Varianz

% Berechnung und Darstellung der Autokorrelationsfunktionen
Ta = fixstep;           % Abtastintervall
T = simudauer;          % Dauer der Signale

% Berechnung des Korrelationszeitintervalls
czeit = (-T:Ta:T);

% Berechnung der Autokorrelationen
xrsig0 = xcorr(rsig0,'biased');
xrsigbp = xcorr(rsigbp,'biased');

% Plot der Autokorrelationsfunktionen
figure
subplot(211)
plot(czeit,xrsig0,'b');
xlabel('Zeit/s')
xlabel('Verschiebung \tau /s')
ylabel('r_{XX}(\tau)')
grid
subplot(212)
plot(czeit,xrsigbp,'k');
xlabel('Verschiebung \tau /s')
ylabel('r_{XX}(\tau)')
grid

