% Script BWTPFilter.m
%
% Aufruf: BWTPFilter
%
% Skript-File zur Illustration des Entwurfs eines
% Butterworth-Tiefpassfilters mit MATLAB
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.02
% Datum: 30.10.2014/18.05.2018

% Filterparameter nach Entwurfsschema festlegen

fp = 1000;                   % Passband-Frequenz in HZ
fs = 2000;                   % Stoppband-Frequenz in Hz

wp = fp*2*pi;
ws = fs*2*pi;                % Umrechnung in rad/s

delta1 = 1-1/sqrt(2);        % Passband-Rippel (linear)
delta2 = 1/10;               % Stppband-Rippel (linear)

Rp = abs(20*log10(1-delta1));
Rs = abs(20*log10(delta2));       % Umrechnung in dB

% Frequenzbereich zur Darstellung in Hz und rad/s

frq = (0:1:3000);
omegs = frq*2*pi;

% Berechnung des Butterworth-Filters

             % Feststellen der Filterordnung mit buttord
             % (Parameter 's', damit analoges Design verwen-
             % det wird!)
[N, wp] = buttord(wp, ws, Rp, Rs, 's');

              % Filterkoeffizienten von H(s) = B(s)/A(s)
              % fr einen Tiefpass mit Grenzfrequenz 1 rad/s
              % damit man mit den tabellierten Filterkoeffizienten
              % vergleichen kann
[BBn,ABn] = butter(N,1,'s');

              % Transformation in die eigentlichen 
              % Filterkoeffizienten mit einer Tiefpass-Tiefpass
              % Transformation
[BB,AB] = lp2lp(BBn,ABn,wp);

% Berechnung der bertragungsfunktion H(j\omega)

HB = freqs(BB,AB,omegs);

% Grafische Darstellung des Amplitudengangs

figure
plot(frq, abs(HB), 'b', 'LineWidth',3)
axis([0,3000,0,1.05])
xlabel('Frequenz/Hz')
ylabel('|H| / linear')
grid
title('Butterworth-Filter')

