% Script Bsp_FahrbahnUnebenheitsSpektrum.m
%
% Aufruf:  Bsp_FahrbahnUnebenheitsSpektrum
%
% Es wird mit Hilfe des Simulink-Systems s_YuleWalkFahrbahn.slx
% ein Fahrbahnunebenheitsignal generiert.
% Die spektrale Leistungsdichte des Signals ist (raue Fahrbahn):
%
%      S_XX(rho) = (1/rho)^(1.75)
%
% Das erzeugte Signal wird spektral analysiert und dem Sollspektrum
% grafisch gegenbergestellt.
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 28.11.2014/21.05.2018


% Initialisierung
init_YuleWalkFahrbahn

% Simulink-System ffen
open_system('s_YuleWalkFahrbahn')

% Simulink-System starten
[t,x,fahrbahnOut] = sim('s_YuleWalkFahrbahn');

% Parmeter der Spektralschtzung
blocklaenge = 2048;        % 2-K-FFTs werden berechnet
ueberlapp = blocklaenge/2; % berlappungsgrad 50%
abtastrate = fa;           % Abtastrate fa in
                           % init_YuleWalkFahrbahn
                           % definiert

% Schtzung des Leistungsdichtespektrums des
% Fahrbahnunebenheitssignals mit der Welch-Methode
% (es wird das ZWEISEITIGE LDS berechnet)
[Sxx,F] = cpsd(fahrbahnOut,fahrbahnOut,rectwin(blocklaenge), ...
    ueberlapp,blocklaenge,abtastrate,'twosided');

figure
% Darstellung des Amplitudengangs (nur positive Frequenzen)
Frq = F(1:length(F)/2);
Pxx = Sxx(1:length(F)/2);
plot(Frq, 10*log10(abs(Pxx)), 'r', 'LineWidth', 2)

% Vergleich mit der gewnschten Spektralcharakteristik
                 % normierte Frequenz in rad
                 % pi entspricht Abtastrate/2
Omega = Frq*2*pi/fa;

                 % gewnschte Filtercharakteristik
magn = (1./(Omega*fa)).^(1.75);
hold
plot(Frq, 10*log10(abs(magn)), 'b', 'LineWidth', 3)
grid
xlabel('Frequenz/1/m')
ylabel('|S_{XX}|/dB')
