% Script Bsp_FormFiltAuswertung.m
%
% Aufruf:  Bsp_FormFiltAuswertung
%
% Berechnung des Leistungsdichtespektrumd des 
% mit [MusFkts] = Bsp_FormFilt(anz, N, fa)
% erzeugten Prozesses.
% 
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 25.11.2014/20.05.2018

anz = 3000;
N = 2*1024;
fa = 100;

[MusFkts] = Bsp_FormFilt(anz, N, fa);

% Berechnung des gemittelten Korrelationssignals
corrAusg = zeros(1,2*N-1);
for k = 1:anz
    corrAusg = corrAusg + xcorr(MusFkts(k,:),'unbiased');
end

corrAusg = corrAusg/anz;

% Leistungsdichte mit Hilfe der FFT berechnen
M = floor(N/2);
K = 1024;         % 1024 Werte aus der Mitte herausschneiden
corrAusgmitte = corrAusg(M-K+1:M+K);   
Phiyy = fft(corrAusgmitte, 2*K);
Phiyy = fftshift(Phiyy);

% Frequenzvektor definieren
df = fa/(2*K);           % Frequenzabstand
frq = (-fa/2:df:fa/2-df);

% Darstellung des Leistungsdichtespektrums
% Wiener-Lee: |H(Omega)|^2 = Phiyy./Phixx
% Phixx wird als konstant 1 angenommen
T = 1/fa;        % fr die Skalierung des diskreten
                 % Leistungsdichtespektrums ntig
plot(frq, sqrt(T*abs(Phiyy)), 'b', 'LineWidth', 2);
grid
xlabel('Frequenz / Hz')
ylabel('Phixx')
axis([-30,30,0,1.2])

% Zu Kontrollzwecken wird die gewnschte Kennlinie eingeplottet
hold
f=(-25:0.01:25);
om = 2*pi*f;
Sxx = cos(om/40).*(om>=-20*pi&om<=20*pi);
plot(f, Sxx, 'r--', 'LineWidth', 2);

