% Skript DFTBsp1.m
%
% Aufruf:  DFTBsp1
%
% Ein einfaches Beispiel zur 
% Diskreten Fourier Transformation
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 13.11.2014/19.05.2018


T = 1/8;                      % Abtastintervall festlegen
N = 8;                        % Zahl der Abtastwerte festlegen
t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
xn = cos(2*pi*t);             % Abtastwerte einer Cosinusschwingung mit
                              % Frequenz 1 Hz bestimmen
n = (0:1:N-1);                % Indexvektor von 0 bis N-1

F1_DFT = zeros(size(n));
for m=0:N-1                   % DFT an N Frequenzpunkten berechnen
                              % Werte der Exponentialfunktion
    expWerte = exp(-1i*2*pi*m*n/N);
                              % DFT-Summe an den Stellen 0 bis N-1
                              % Da MATLAB ab 1 indiziert, muss Index
                              % um 1 erhht werden.
    F1_DFT(m+1) = sum(xn.*expWerte);
end

                              % DFT-Werte im Command-Window anzeigen
F1_DFT'

nfreq = (0:pi/4:(N-1)*pi/4);  % Frequenzvektor in normierter Frequenz rad
                              % definieren
                              
% Alternativ: Frequenzvektor in Hz                             
%nfreq = (0:1:(N-1));          % Frequenzvektor in Hz
%                              % definieren

                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
figure
stem(nfreq, abs(F1_DFT), 'b', 'LineWidth',3)  
grid
                              
%xlabel('Frequenz / Hz')
xlabel('Normierte Frequenz / rad')
ylabel('|DFT|')
                              
% Weitere DFT mit mehr Punkten berechnen                                                           
N = 16;                       % Zahl der Abtastwerte festlegen
t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
xn = cos(2*pi*t);             % Abtastwerte einer Cosinusschwingung mit
                              % Frequenz 1 Hz bestimmen

n = (0:1:N-1);                % Indexvektor von 0 bis N-1
F2_DFT = zeros(size(n));
for m=0:N-1                   % DFT an N Frequenzpunkten berechnen
                              % Werte der Exponentialfunktion
    expWerte = exp(-1i*2*pi*m*n/N);
                              % DFT-Summe an den Stellen 0 bis N-1
                              % Da MATLAB ab 1 indiziert, muss Index
                              % um 1 erhht werden.
    F2_DFT(m+1) = sum(xn.*expWerte);
end

figure                        % Neues Darstellungsfenster aufmachen
nfreq = (0:1/2:(N-1)*(1/2));  % Frequenzvektor in Hz
                              % definieren
                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
stem(nfreq, abs(F2_DFT), 'b', 'LineWidth',3)    
grid
                              
xlabel('Frequenz / Hz')
ylabel('|DFT|')


% Weitere DFT mit mehr Punkten berechnen                                                          
N = 32;                       % Zahl der Abtastwerte festlegen
t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
xn = cos(2*pi*t);             % Abtastwerte einer Cosinusschwingung mit
                              % Frequenz 1 Hz bestimmen

n = (0:1:N-1);                % Indexvektor von 0 bis N-1
F3_DFT = zeros(size(n));
for m=0:N-1                   % DFT an N Frequenzpunkten berechnen
                              % Werte der Exponentialfunktion
    expWerte = exp(-1i*2*pi*m*n/N);
                              % DFT-Summe an den Stellen 0 bis N-1
                              % Da MATLAB ab 1 indiziert, muss Index
                              % um 1 erhht werden.
    F3_DFT(m+1) = sum(xn.*expWerte);
end

figure                        % Neues Darstellungsfenster aufmachen
nfreq = (0:1/4:(N-1)*(1/4));  % Frequenzvektor in Hz
                              % definieren
                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
stem(nfreq, abs(F3_DFT), 'm', 'LineWidth',3)   
grid
                              
xlabel('Frequenz / Hz')
ylabel('|DFT|')
