% Skript DFTBsp2.m
%
% Aufruf:  DFTBsp2
%
% Ein einfaches Beispiel zur 
% Diskreten Fourier Transformation
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 13.11.2014/19.05.2018



T = 1/9;                      % Abtastintervall festlegen
N = 8;                        % Zahl der Abtastwerte festlegen
t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
xn = cos(2*pi*t);             % Abtastwerte einer Cosinusschwingung mit
                              % Frequenz 1 Hz bestimmen
n = (0:1:N-1);                % Indexvektor von 0 bis N-1

F_DFT = zeros(size(n));                           
for m=0:N-1                   % DFT an N Frequenzpunkten berechnen
                              % Werte der Exponentialfunktion
    expWerte = exp(-1i*2*pi*m*n/N);
                              % DFT-Summe an den Stellen 0 bis N-1
                              % Da MATLAB ab 1 indiziert, muss Index
                              % um 1 erhht werden.
    F_DFT(m+1) = sum(xn.*expWerte);
end

                              % DFT-Werte im Command-Window anzeigen
F_DFT'

fa = 1/T;
nfreq = (0:fa/N:(N-1)*fa/N);  % Frequenzvektor in Hz
                              % definieren
                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
figure
stem(nfreq, abs(F_DFT), 'b', 'LineWidth',3)    
grid
                            
xlabel('Frequenz / Hz')
axis([0,9,0,4.5])
ylabel('|DFT|')
                              
