% Skript DFTBsp3.m
%
% Aufruf:  DFTBsp3
%
% Weitere einfache Beispiele zur 
% Diskreten Fourier Transformation
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.02
% Datum: 13.11.2014


T = 1/8;                      % Abtastintervall festlegen
fa = 8;
N = 16;                       % Zahl der Abtastwerte festlegen
t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
xn = cos(2*pi*t);             % Abtastwerte einer Cosinusschwingung mit
                              % Frequenz 1 Hz bestimmen

n = (0:1:N-1);                % Indexvektor von 0 bis N-1
F1_DFT = zeros(N,1);          % DFT-Vektor vorinitialisieren
for m=0:N-1                   % DFT an N Frequenzpunkten berechnen
                              % Werte der Exponentialfunktion
    expWerte = exp(-1i*2*pi*m*n/N);
                              % DFT-Summe an den Stellen 0 bis N-1
                              % Da MATLAB ab 1 indiziert, muss Index
                              % um 1 erhht werden.
    F1_DFT(m+1) = sum(xn.*expWerte);
end

figure                        % Neues Darstellungsfenster aufmachen
subplot(221)

nfreq = (0:fa/N:(N-1)*fa/N);  % Frequenzvektor in Hz
                              % definieren
                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
stem(nfreq, abs(F1_DFT), 'b', 'LineWidth',3)  
grid
axis([0,8,0,18])                              
xlabel('Frequenz / Hz')
ylabel('|DFT|')


% Weitere DFT mit mehr Punkten berechnen                                                         
N = 32;                       % Zahl der Abtastwerte festlegen
t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
xn = cos(2*pi*t);             % Abtastwerte einer Cosinusschwingung mit
                              % Frequenz 1 Hz bestimmen

n = (0:1:N-1);                % Indexvektor von 0 bis N-1
F2_DFT = zeros(N,1);          % DFT-Vektor vorinitialisieren
for m=0:N-1                   % DFT an N Frequenzpunkten berechnen
                              % Werte der Exponentialfunktion
    expWerte = exp(-1i*2*pi*m*n/N);
                              % DFT-Summe an den Stellen 0 bis N-1
                              % Da MATLAB ab 1 indiziert, muss Index
                              % um 1 erhht werden.
    F2_DFT(m+1) = sum(xn.*expWerte);
end

subplot(223)
nfreq = (0:fa/N:(N-1)*fa/N);  % Frequenzvektor in Hz
                              % definieren
                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
stem(nfreq, abs(F2_DFT), 'b', 'LineWidth',3)    
grid
axis([0,8,0,18])                                   
xlabel('Frequenz / Hz')
ylabel('|DFT|')

% Gleiche Berechnung fr Abtastrate 9 Hz
T = 1/9;                      % Abtastintervall festlegen
fa = 9;
N = 16;                       % Zahl der Abtastwerte festlegen
t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
xn = cos(2*pi*t);             % Abtastwerte einer Cosinusschwingung mit
                              % Frequenz 1 Hz bestimmen

n = (0:1:N-1);                % Indexvektor von 0 bis N-1
F3_DFT = zeros(N,1);          % DFT-Vektor vorinitialisieren
for m=0:N-1                   % DFT an N Frequenzpunkten berechnen
                              % Werte der Exponentialfunktion
    expWerte = exp(-1i*2*pi*m*n/N);
                              % DFT-Summe an den Stellen 0 bis N-1
                              % Da MATLAB ab 1 indiziert, muss Index
                              % um 1 erhht werden.
    F3_DFT(m+1) = sum(xn.*expWerte);
end

subplot(222)
nfreq = (0:fa/N:(N-1)*fa/N);  % Frequenzvektor in Hz
                              % definieren
                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
stem(nfreq, abs(F3_DFT), 'k', 'LineWidth',3)  
grid
axis([0,9,0,18])                              
xlabel('Frequenz / Hz')
ylabel('|DFT|')

% Weitere DFT mit mehr Punkten berechnen                                                        
N = 32;                       % Zahl der Abtastwerte festlegen
t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
xn = cos(2*pi*t);             % Abtastwerte einer Cosinusschwingung mit
                              % Frequenz 1 Hz bestimmen

n = (0:1:N-1);                % Indexvektor von 0 bis N-1
F4_DFT = zeros(N,1);          % DFT-Vektor vorinitialisieren
for m=0:N-1                   % DFT an N Frequenzpunkten berechnen
                              % Werte der Exponentialfunktion
    expWerte = exp(-1i*2*pi*m*n/N);
                              % DFT-Summe an den Stellen 0 bis N-1
                              % Da MATLAB ab 1 indiziert, muss Index
                              % um 1 erhht werden.
    F4_DFT(m+1) = sum(xn.*expWerte);
end

subplot(224)
nfreq = (0:fa/N:(N-1)*fa/N);  % Frequenzvektor in Hz
                              % definieren
                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
stem(nfreq, abs(F4_DFT), 'k', 'LineWidth',3)
grid
axis([0,9,0,18])                                   
xlabel('Frequenz / Hz')
ylabel('|DFT|')

