% Skript DFTBsp4.m
%
% Aufruf:  DFTBsp4
%
% Beispiel der Diskreten Fourier Transformation
% eines approximativ bandbegrenzten a-periodischen
% Signals
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 13.11.2014/19.05.2018


T = 1/20;                     % Abtastintervall festlegen
fa = 20;
N = 64;                       % Zahl der Abtastwerte festlegen
t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
                              % Abtastwerte des Beispielsignals
fn = exp(-t).*sin(4*t);           

n = (0:1:N-1);                % Indexvektor von 0 bis N-1
F1_DFT = zeros(N,1);          % DFT-Vektor vorinitialisieren
for m=0:N-1                   % DFT an N Frequenzpunkten berechnen
                              % Werte der Exponentialfunktion
    expWerte = exp(-1i*2*pi*m*n/N);
                              % DFT-Summe an den Stellen 0 bis N-1
                              % Da MATLAB ab 1 indiziert, muss Index
                              % um 1 erhht werden.
    F1_DFT(m+1) = sum(fn.*expWerte);
end

figure                        % Neues Darstellungsfenster aufmachen
subplot(121)

nfreq = (0:fa/N:(N-1)*fa/N);  % Frequenzvektor in Hz
                              % definieren
                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
plot(nfreq, abs(F1_DFT), 'b', 'LineWidth',3)  
grid
axis([0,10,0,12])                              
xlabel('Frequenz / Hz')
ylabel('|DFT|')


% Weitere DFT mit mehr Punkten berechnen                                                          
N = 256;                      % Zahl der Abtastwerte festlegen
t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
                              % Abtastwerte des Beispielsignals
fn = exp(-t).*sin(4*t);     

n = (0:1:N-1);                % Indexvektor von 0 bis N-1
F2_DFT = zeros(N,1);          % DFT-Vektor vorinitialisieren
for m=0:N-1                   % DFT an N Frequenzpunkten berechnen
                              % Werte der Exponentialfunktion
    expWerte = exp(-1i*2*pi*m*n/N);
                              % DFT-Summe an den Stellen 0 bis N-1
                              % Da MATLAB ab 1 indiziert, muss Index
                              % um 1 erhht werden.
    F2_DFT(m+1) = sum(fn.*expWerte);
end

subplot(122)
nfreq = (0:fa/N:(N-1)*fa/N);  % Frequenzvektor in Hz
                              % definieren
                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
plot(nfreq, abs(F2_DFT), 'k', 'LineWidth',3)    
grid
axis([0,10,0,12])                                   
xlabel('Frequenz / Hz')
ylabel('|DFT|')

