% Skript DFTBsp5.m
%
% Aufruf:  DFTBsp5
%
% Beispiele zur Linienhhe eines harmonischen
% Anteils bei der diskreten Fourier Transformation
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 13.11.2014/19.05.2018

T = 1/9;                      % Abtastintervall festlegen
fa = 9;
N = 1024;                     % Zahl der Abtastwerte festlegen
% N = 4*1024;                 % ggf. hier editieren

t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
xn = cos(2*pi*t);             % Abtastwerte einer Cosinusschwingung mit
                              % Frequenz 1 Hz bestimmen
F_DFT = fft(xn,N);            % DFT-Spektrum berechnen
F_DFT = fftshift(F_DFT);      % Spektrum um 0 Hz darstellen
                              % Frequenzvektor in Hz definieren
nfreq = (-fa/2:fa/N:-fa/2+(N-1)*fa/N);  
                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
figure
stem(nfreq, abs(F_DFT), 'k', 'LineWidth',3)  
grid
axis([-1.1,1.1,0,1.1*max(abs(F_DFT))])                              
xlabel('Frequenz / Hz')
ylabel('|DFT|')


