% Skript DTFTBsp.m
%
% Aufruf:  DTFTBsp
%
% Beispiel zur Berechnung einer
% Zeitdiskreten Fourier Transformation (DTFT)
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.20
% Datum: 13.11.2014/19.05.2018

syms z
a = 1/2;

% Definition der Z-Transformierten als symbolischer
% Ausdruck
H = z/(z-a);

% Definition des normierten Frequenzbereiches
Omega = (-pi:0.1:pi);

% Substitution von z = exp(j*Omega)
Hnum = double(subs(H,z,exp(1i*Omega)));

% Grafische Darstellung der DTFT
figure
subplot(211)
plot(Omega,abs(Hnum),'b','Linewidth',3);
axis([-pi,pi,0,1.1*max(abs(Hnum))])
grid
xlabel('Normierte Frequenz/rad')
ylabel('|H|')

subplot(212)
plot(Omega,angle(Hnum),'k','Linewidth',3);
axis([-pi,pi,-1.1*pi,1.1*pi])
grid
xlabel('Normierte Frequenz/rad')
ylabel('arg(H)')
