% Skript DTFTBsp2.m
%
% Aufruf:  DTFTBsp2
%
% Beispiel zur (approximativen) Berechnung einer
% Zeitdiskreten Fourier Transformation (DTFT)
%
% Es wird die DTFT der (kausalen) Folge
%
% x_0 = 1,
% x_n = cos(pi*n/5)/(n^2) fr n>=1
%
% berechnet.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 13.11.2014/19.05.2018


% Abbruch der Folge x_n fr n=100
n = (1:1:100);
xn = [1, cos(pi*n/5)./(n.^2)];
n = [0,n];

% Definition des normierten Frequenzbereiches
Omega = (-pi:0.1:pi);

% Realisierung der DTFT-"Reihe" fr jedes Omega 
% des Frequenzrasters
DTFT = [];    % Vorinitialisierung der DTFT-Werte

for  k = 1:length(Omega)
    expOmegk = exp(-1i*Omega(k)*n);
              % Reihensumme fr Frequenz Omega(k)
    DTFT = [DTFT, xn*expOmegk']; 
end

% Grafische Darstellung der DTFT
figure
subplot(211)
plot(Omega,abs(DTFT),'b','Linewidth',3);
grid
xlabel('Normierte Frequenz/rad')
ylabel('|DTFT|')
axis([-pi, pi, 0, 1.1*max(abs(DTFT))])

subplot(212)
plot(Omega,angle(DTFT),'k','Linewidth',3);
grid
xlabel('Normierte Frequenz/rad')
ylabel('arg(DTFT)')
axis([-pi, pi, 1.1*min(angle(DTFT)), 1.1*max(angle(DTFT))])