% Scrpit File FIREntwurfBsp.m
%
% Aufruf: FIREntwurfBsp
%
% Beispiel zum FIR-Filter-Entwurf - Anpassung an eine 
% Tiefpassfilter-bertragungsfunktion mit der Fenster-Methode
% und mit dem Remez-Exchange-Algorithmus (MATLAB-Funktion
% firpm)
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/19.05.2018


% Approximation mit der Fenster-Methode
% (Fenster-Methode, Fensterung der idealen Impulsantwort)
N = 50;                           % Zahl der Koeffizienten 2*N+1
                                  % (kann hier gendert werden!)
Omegag = pi/3;                    % gewnschet Grenzfrequenz
Omegas = pi/3+0.1;                % gewnschet Sperrfrequenz

k=(-N:1:N);                       % abgeschnittene Impulsantwort
ak = (cos(k*Omegag)-cos(k*Omegas))./(pi*k.^2.*(Omegas-Omegag));
ind = isnan(ak);                  % Wert fr k=0 direkt einsetzen;
ak(ind)=(Omegas+Omegag)/(2*pi);

% Approximation mit dem Remez-Exchange-Algorithmus
% (Tschebyscheff-Approximation des Amplitudengangs)
                                  % Kennlinie des idealen Tiefpassfilters
                                  % definieren
fg = Omegag/pi;                   % Normierung auf [0,1]; wird fr firpm
                                  % bentigt  
fs = Omegas/pi;                   % Normierung auf [0,1]; wird fr firpm
                                  % bentigt                                    
f = [0,fg,fs,1];
TPdef = [1,1,0,0];                % Amplitudengang des gewnschten TP mit
                                  % Grenzfrequenz Omegag = pi/3
bk = firpm(2*N,f,TPdef);          % Impulsantwort berechnen


% Vergleich der Impulsantworten
figure                            % Stem-Plot der Impulsantworten
stem(k,ak,'k', 'LineWidth',2)  
xlabel('k/Index')
ylabel('h(k)')
title('Impulsantwort mit Fenster-Methode')
grid

figure
stem(k,bk,'b', 'LineWidth',2)
xlabel('k/Index')
ylabel('h(k)')
title('Impulsantwort mit Remez')
grid

% Vergleich der bertragungsfunktionen
Omega = (-pi:0.01:pi);            % normierte Frequenz
hTpa = freqz(ak,1,Omega);         % Erste Methode
hTpb = freqz(bk,1,Omega);         % Zweite Methode
                                  % ideale Charakteristik
TP1 = (Omega<Omegag)&(Omega>-Omegag);
TP2 = (Omega+Omegas)/(Omegas-Omegag).*((Omega<-Omegag)&(Omega>-Omegas));
TP3 = (Omegas-Omega)/(Omegas-Omegag).*((Omega<Omegas)&(Omega>Omegag));
TP = TP1+TP2+TP3;
                                  % Plot der Amplitudengnge
figure
plot(Omega,TP,'k', Omega,abs(hTpa),'k','LineWidth',2)                    
xlabel('Normierte Frequenz /rad')
ylabel('|H|')
title('Filter mit Fenster-Methode')
grid

figure
plot(Omega,TP,'k', Omega,abs(hTpb),'b', 'LineWidth',2)                    
xlabel('Normierte Frequenz /rad')
ylabel('|H|')
title('Filter mit Remez')
grid



