% Skript FT_DFTBsp.m
%
% Aufruf:  FT_DFTBsp
%
% Beispiel zur Berechnung von Fourierkoeffizienten
% mit Hilfe einer Diskreten Fourier Transformation
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/19.05.2018

T0 = 1/10;                         % Periodendauer des Dreieckssignals
fa = 256;                          % gewhlte Abtastrate
T = 1/fa;                          % und zugehriges Abtastintervall
N = 128;                           % gewhlte Zahl der Abtastwerte  
t = (0:T:(N-1)*T);                 % Abtastzeitpunkte festlegen

% Abtastwerte der Dreiecksschwingung berechnen
% Die Dreieckschwingung wird im Intervall [0,NT]
% mit den gewhlten Parametern 5 mal wiederholt.
xn = dreieck(T0,t)+dreieck(T0,t-T0)+...
    dreieck(T0,t-2*T0)+dreieck(T0,t-3*T0)+...
    dreieck(T0,t-4*T0);
  
% Grafische Darstellung des abgetasteten Signals
figure
plot(t,xn, 'b', 'LineWidth',3);
xlabel('Zeit/t')
ylabel('Ampl.')
grid
  
F_DFT = fft(xn,N);            % DFT-Spektrum berechnen
                              % Frequenzvektor in Hz definieren
nfreq = (0:fa/N:(N-1)*fa/N);  
                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
figure
stem(nfreq, abs(F_DFT) , 'k', 'LineWidth',3)  
grid
axis([0, fa/2, -0.1, 1.1*max(abs(F_DFT))])                              
xlabel('Frequenz / Hz')
ylabel('|DFT|')

% Werte der geschtzten Fourierkoeffizienten
% auf dem Bildschirm ausgeben
Fcoeffs = F_DFT(1:N/2)/N;
Fcoeffs = Fcoeffs(:);         % Spaltenvektor
Gleichwert = Fcoeffs(1)       % Gleichwert
FRKoeffs = Fcoeffs(6:5:end)   % DFT-Werte bei den
                              % Harmomischenfrequenzen      

