% Script GlGewMconv.m
%
% Aufruf: GlGewMconv
%
% Skript-File zur Simulation einer Gleitenden
% Gewichteten Mittelung von Eingangssignalen
% Die Simulation wird in dieser Version mit der
% MATLAB-Faltungsfunktion conv durchgefhrt!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 06.11.2014/19.05.2018 

% Impulsantwort definieren
h = (1/9)*[1 2 3 2 1];
K = length(h);

% Frequenz des sinusfrmigen Eingangssignals in Hz definieren
% (und ggf. hier editieren)
frq = 2;
% frq = 10;

% Abtastrate fa festlegen
fa = 50;
Ta = 1/fa;

% Sinusfrmiges Eingangssignal abtasten
tn = (0:Ta:5);  
xn = sin(2*pi*frq*tn);

% Simulation der gleitenden  gewichteten 
% Mittelung mit Hilfe der FALTUNG
yn = conv(xn,h);

% Grafische Darstellung der Simulation
% Zeitpunkte berenchen, an denen die 
% Faltung ungleich 0 ist (beachten!!!!)
tfalt = (0:Ta:5+(K-1)*Ta);        
stairs(tfalt,yn,'b-','LineWidth',3);
grid
axis([tfalt(1), tfalt(end), min(yn), max(yn)])
xlabel('Index/n')
ylabel('Amp')

