% Script GlGewMittel.m
%
% Aufruf: GlGewMittel
%
% Skript-File zur Simulation einer Gleitenden
% Gewichteten Mittellung von Eingangssignalen
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 13.07.2010/19.05.2018

% Koeffizienten definieren
h = (1/9)*[1 2 3 2 1];
K = length(h);

% Frequenz des sinusfrmigen Eingangssignals in Hz definieren
% frq = 10;  
frq = 2;  %%% (ggf. hier editieren)

% Zeitintervall fr die grafische Darstellung festlegen
t = (0:0.01:5);
x = sin(2*pi*frq*t);

% Abtastrate fa festlegen
fa = 50;
Ta = 1/fa;

% Sinusfrmiges Eingangssignal abtasten
tn = (0:Ta:5); N = length(tn);
xn = sin(2*pi*frq*tn);

% Simulation der gleitenden  gewichteten 
% Mittellung mit Hilfe einer for-Schleife
% Vorinitialisierung
yn = [zeros(1,N)]; 
xntilde = [zeros(1,K), xn];

for k=1:N
    % Berechnung nach Formel
    yn(k) = xntilde(k:k+K-1)*h';
end

% Grafische Darstellung der Simulation
% in einem eingeschwungenen Bereich
plot(t,x,'b-','LineWidth',3);
hold
stairs(tn,yn,'k-','LineWidth',3);
grid
axis([4, 5, -1.1, 1.1])
xlabel('Zeit/s')
ylabel('Amp')
hold off
