% Script KorrAkustLaufZeit.m
%
% Aufruf:  KorrAkustLaufZeit
%
% Berechnet die Laufzeit eines akustischen Signals zwischen
% zwei Mikrofonen.
% 
% Die Signale sind im mat-File LaufzeitAkustWN.mat abgelegt
% und mssen im selben Verzeichnis wie dieses Script-File liegen.
%
% Es wird der Zeitversatz berechnet und das Korrelationssignal
% grafisch dargestellt. Anschlieend wird aufgrund dieser
% Laufzeitbestimmung ber die bekannte Ausbreitungsgeschwindig-
% keit des Schalls in Luft bei Zimmertemperatur (343 m/s)
% der Abstand der Mikrofone geschtzt.
%
% In dem der Messung LaufzeitAkustWN.mat zu Grunde liegenden Versuch
% war ein Abstand von 50 cm eingestellt.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 28.11.2014/20.05.2018

% Laden der Signale
load LaufzeitAkustWN.mat 

% Zunchst werden Mittelwert und ggf. vorhandene
% lineare Trends aus den Sensorsignalen eliminiert
MikroVorne = detrend(MikroVorne);
MikroHinten = detrend(MikroHinten);

% Der Zeitoffset der Messung wird eliminiert und so
% die Anfangszeit der Messung auf 0 gestetzt
zeit = t-t(1);

% Bestimmung der Abtastrate (quidistante 
% Abtastung ist vorausgesetzt)
dt = zeit(2)-zeit(1);
T = zeit(end)-zeit(1); % Signaldauer in sec
N = length(zeit);      
                       % Korrelationszeitvektor
czeit = (-T:dt:N*dt); 

% Berechnung der Kreuzkorrelation von 
% MikroVorne und MikroHinten
corsig = xcorr(MikroVorne, MikroHinten,'biased');

% Grafische Darstellung
figure
plot(czeit,corsig,'r','LineWidth',2)
title('Korrelation der Mikrofonsignale')
xlabel('Zeit/s')
grid

% Ausschnittsvergrerung der grafischen Darstellung
figure
plot(czeit,corsig,'b','LineWidth',3)
xlabel('Zeit/s')
grid
axis([-0.003,0.0,1.1*min(corsig),1.1*max(corsig)])

% Berechnung des Zeitversatzes
[maxm,ind] = max(corsig);
laufzeit = czeit(ind);

% Berechnung der Entfernung der Mikrofone in cm
dMicro = laufzeit*343*100;

fprintf('\n\nGemessene Laufzeit in s :     %10.5f',abs(laufzeit));
fprintf('\n\nGemessener Abstand in cm:     %5.3f\n\n',abs(dMicro));
