% Script KorrCDPunkte.m
%
% Aufruf:  KorrCDPunkte
%
% Berechnet den Zeitversatz zweier Signale, die durch Abtastung
% einer bedruckten rotierenden CD mittels Infrarotsensoren 
% gemessen wurden. Die CD ist im vorliegenden Fall mit dicken,
% ber die Flche GLEICHVERTEILTEN Punkten bedruckt.
% 
% Die Signale sind im mat-File SignaleCDdickePunkte.mat abgelegt
% und mssen im selben Verzeichnis wie dieses Script-File liegen.
%
% Es wird der Zeitversatz berechnet und das Korrelationssignal
% grafisch dargestellt.
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 28.11.2014/20.05.2018

% Laden der Signalmatrix
load SignaleCDdickePunkte

% Entnahme der einzelnen Signale
zeit = SignaleCDdickePunkte(:,1);
kanal1 = SignaleCDdickePunkte(:,2);
kanal2 = SignaleCDdickePunkte(:,3);

% Bestimmung der Abtastrate (quidistante 
% Abtastung ist vorausgesetzt)
dt = zeit(2)-zeit(1);
T = zeit(end)-zeit(1); % Signaldauer in sec
N = length(zeit);      
                       % Korrelationszeitvektor
czeit = (-T:dt:N*dt); 

% Berechnung der Kreuzkorrelation von 
% kanal1 und kanal2
corsig = xcorr(kanal1,kanal2,'biased');

% Grafische Darstellung
figure
plot(czeit,corsig,'r','LineWidth',3)
title('CD mit vielen dicken Punkten')
xlabel('Zeit/s')
grid

% Berechnung des Zeitversatzes
[maxm,ind] = max(corsig);
ZeitVCDdickePunkte = czeit(ind)


