% Script RCSimuOrd0.m
%
% Aufruf: RCSimuOrd0
%
% Skript-File zur Simulation 0-ter Ordnung
% eines RC-Tiefpasses mit Zeitkonstante T=1
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 13.07.2010/17.05.2018

% bertragungsfunktion des RC-Tiefpass
% definieren
T = 1;
s = tf('s');
H = 1/(T*s+1);

% Frequenz des sinusfrmigen Eingangssignals in Hz definieren
% (es wird ein 2 Hz-Sinus simuliert)
frq = 2;

% Amplituden- und Phasennderung berechnen
[Amp,phas] = bode(H,2*pi*frq);

% Nullphase in rad umrechnen
nphas = 2*pi*phas/360;

% Zeitintervall fr die grafische Darstellung festlegen
t = (0:0.01:5);

% Theoretisches Ausgangssignal des RCTP berechnen
sigaus = Amp*sin(2*pi*frq*t+nphas);

% Abtastrate fa festlegen
% fa = 10;  
fa = 25;  % (ggf. Script hier editieren)
Ta = 1/fa;

% Sinusfrmiges Eingangssignal abtasten
tn = (0:Ta:5); N = length(tn);
xn = sin(2*pi*frq*tn);

% Simulation mit Hilfe einer for-Schleife
% Vorinitialisierung
yn1 = [xn(1)*Ta/(T+Ta), zeros(1,N-1)]; 
yn2 = [xn(1)*Ta/T, zeros(1,N-1)];  

for k=2:N
    % Berechnung nach Formel 1 (s. Buch)
    yn1(k) = yn1(k-1)*T/(T+Ta)+xn(k)*Ta/(T+Ta);
    % Berechnung nach Formel 2 (s. Buch)
    yn2(k) = yn2(k-1)*exp(-Ta/T)+xn(k)*Ta/T;
end

% Grafische Darstellung der Simulation
% in einem eingeschwungenen Bereich
plot(t,sigaus,'b-','LineWidth',3);
hold
stairs(tn,yn1,'k-','LineWidth',3);
stairs(tn,yn2,'r--','LineWidth',3);

% zum Vergleich noch die Darstellung als
% Polygonzug (lineare Verbindung zwischen den Werten)
% fr die Formel 1
plot(tn,yn1,'g-','LineWidth',3);
grid
axis([4, 5, -1.2*Amp, 1.2*Amp])
xlabel('Zeit/s')
ylabel('Amp')
hold off
