function [t,Y] = SimBLWNoise(N)
%
% Funktion  SimBLWNoise
%
% Aufruf:  [t,Y] = SimBLWNoise(N)
%
% Aufrufbeispiel: [t,Y] = SimBLWNoise(20)
%
% Simuliert das Simulink-System s_blwnoise zur Simulation eines
% bandbegrenzten weien Rauschens N mal durch
% und speichert die Rauschsignale in Y Spaltenweise.
% 
% Eingabeparameter:    N       Zahl der Simulationen
%                          
% Ausgabeparameter:    Y       Matrix der Simulationsergebnisse
%                               (eine Spalte = eine Lsung)
%                      t       Zeitvektor
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 22.11.2014/20.05.2018


% Simulink-System ffen
open_system('s_blwnoise')

% Initialisierung der Ausgabematrix Y als leere Matrix
Y = [ ];

% Aufruf der Iterationsschleife fr die Simulation
% Es mu in dieser Programmversion sichergestellt
% sein, da ein Fixed-Step-Verfahren im Parameter-
% fenster eingestellt ist !!

% Initialisierung der Simulationsparameter
stoptime = 10;     % Simulationsdauer
stime = 0.01;      % 1/simulierte Abtastrate
ndichte = stime;   % Leistungsdichte des Rauschens

fixstep = stime;   % Schrittweite der Fixed-Step Simulation

set_param('s_blwnoise','FixedStep',num2str(fixstep));
set_param('s_blwnoise','StopTime',num2str(stoptime));
                  
                  % Rauschblockparameter definieren
set_param('s_blwnoise/Rauschsignal','TS',num2str(stime) );
set_param('s_blwnoise/Rauschsignal','cov',num2str(ndichte));

for i=1:N  
   % Setzen der Rauschblock-Parameter mit set_param
   % fr jede neue Iteration!
  
                   % Initialisierung Zufallsgenerator
    pause(0.1);
    derseed = num2str(floor(sum(100*clock)));
    set_param('s_blwnoise/Rauschsignal','seed',derseed );

   [t,x,y] = sim('s_blwnoise');
   Y = [Y,y];
end;




