function [t, Y, ct, rxx, frq, Sxx] = SimBLWNoiseLDS(N)
%
% Funktion  SimBLWNoiseLDS
%
% Aufruf:  [rxx, Sxx] = SimBLWNoiseLDS(N)
%
% Aufrufbeispiel: [t, Y, ct, rxx, frq, Sxx] = SimBLWNoiseLDS(20)
%
% Simuliert das Simulink-System s_blwnoise zur Simulation eines
% bandbegrenzten weien Rauschens N mal durch,
% berechnet die N Autokorrelationsfunktionen, mittelt diese
% und berechnet mit Hilfe einer FFT das Leistungdichtespektrum (LDS)
% 
% Eingabeparameter:    N       Zahl der Simulationen
%                          
% Ausgabeparameter:    ct      Zeitvektor fr die Autokorrelation
%                      rxx     gemittelte Autokorrelation
%                      frq     Frequenzvektor fr das LDS
%                      Sxx     Leistungdichtespektrum (LDS)
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 24.04.2007/20.05.2018


% Simulink-System N Mal durchsimulieren
[t,Y] = SimBLWNoise(N);

% Korrelationszeitvektor
dt = t(2)-t(1);      % quidistante Abtastung vorausgesetzt
ct = (-t(end):dt:t(end));

% Frequenzvektor
fa = 1/dt;
N = length(t);
df = fa/N;              % df = fa/N
frq = (-fa/2:df:fa/2-df);

% Korrelationen und Mittelung
Y = Y';
[n,m] = size(Y);
rxx = zeros(1, 2*m-1);
for k=1:n
    rxx = rxx + xcorr(Y(k,:), 'biased');
end

rxx = rxx/n;
% Leistungsdichte mit Hilfe der FFT

K = floor(N/2);
rxxmitte = rxx(m-K:m+K);   % N Werte SYMMETRISCH rausschneiden
Sxx = fft(rxxmitte);
Sxx = fftshift(Sxx);
