function [F,Pxx,Pyy,H] = SystemIdentRC1(EingangRC,AusgangRC,fa,NFFT)
%
% Beispielaufruf:  (nach load load('VersuchRCTP.mat')
%   [F,Pxx,Pyy,H] = SystemIdentRC1(EingangRC,AusgangRC,125000,1024);
%
%
% Systemidentifikation eines RC-Tiefpasses
%
% Eingangsparameter:       EingangRC     gemessenes Eingangssignal
%                                        des RC-Tiefpasses
%                          AusgangRC     gemessenes Ausgangssignal
%                                        des RC-Tiefpasses
%                          t             Abtastzeitpunkte
%                          fa            Abtastrate in Hz
%                          NFFT          FFT-Lnge fr cpsd 
%
% Ausgangsparameter:       F             Frequenzvektor
%                          Pxx           Leistungsdichte Eingangssignal
%                          Pyy           Leistungsdichte Ausgangssignal
%                          H             Geschtzter Amplitudengang des
%                                        RC-Tiefpasses
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 28.11.2014/21.05.2018


% berlappungsgrad fr die Welch-Periodogramm-Schtzung
NOVERLAP = NFFT/2;

% Signale mit detrend um Mittelwert und Tends bereinigen
EingangRC = detrend(EingangRC);
AusgangRC = detrend(AusgangRC);

% Leistungsdichtespektrum Eingangssignal berechnen
[Pxx,~] = cpsd(EingangRC,EingangRC,bartlett(NFFT),NOVERLAP,NFFT,fa);

% Leistungsdichtespektrum Ausgangssignal berechnen
[Pyy,F] = cpsd(AusgangRC,AusgangRC,bartlett(NFFT),NOVERLAP,NFFT,fa);

% Amplitudengang (bertragungsfunktion) berechnen
H = abs(Pyy./Pxx);

% und grafisch darstellen
figure
semilogx(F,10*log10(H),'b','LineWidth',3)
grid
xlabel('Frequenz/Hz')
ylabel('|H|')

% Theoretischen Amplitudengang darber plotten
R = 10000;        % 10 kOhm
C = 0.1*10^(-6);  % 0.1 muF
T = R*C;          % Zeitkonstante des RCTP
                  % Theoretischer Amplitudengang
Hth = abs(1./(1+T*1i*F*2*pi));
hold
semilogx(F,20*log10(Hth),'r--','LineWidth',2)
axis([100,10000,-35,0])


