function [F,Pxx,Pyy,H,T,A] = SystemIdentRC2(EingangRC,AusgangRC,fa,block)
%
% Beispielaufruf:  (nach load load('VersuchRCTP.mat')
%   [F,Pxx,Pyy,H] = SystemIdentRC2(EingangRC,AusgangRC,125000,5000);
%   [F,Pxx,Pyy,H] = SystemIdentRC2(EingangRC,AusgangRC,125000,1000);
%
% Systemidentifikation eines RC-Tiefpasses
%
% Eingangsparameter:       EingangRC     gemessenes Eingangssignal
%                                        des RC-Tiefpasses
%                          AusgangRC     gemessenes Ausgangssignal
%                                        des RC-Tiefpasses
%                          t             Abtastzeitpunkte
%                          fa            Abtastrate in Hz
%                          block         Lnge eines Datenblocks fr 
%                                        die Berechnung der DFT
%
% Ausgangsparameter:       F             Frequenzvektor
%                          Pxx           Leistungsdichte Eingangssignal
%                          Pyy           Leistungsdichte Ausgangssignal
%                          H             Geschtzter Amplitudengang des
%                                        RC-Tiefpasses
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 28.11.2014/21.05.2018


% Signale mit detrend um Mittelwert und Tends bereinigen
EingangRC = detrend(EingangRC);
AusgangRC = detrend(AusgangRC);

% Frequenzvektor fr die Darstellung definieren
% Frequenzauflsung 1 Hz
f=(1:1:1000);
 
% Leistungsdichtespektrum Eingangssignal 
[~, Pxx] = psddft(EingangRC,block,f,fa);
 
% Leistungsdichtespektrum Ausgangssignal 
[F, Pyy] = psddft(AusgangRC,block,f,fa);
  
% Amplitudengang (bertragungsfunktion) berechnen
H = abs(Pyy./Pxx);

% und grafisch darstellen
figure
semilogx(F,10*log10(H),'b','LineWidth',2)
grid
xlabel('Frequenz/Hz')
ylabel('|H|')

% Finde RCTP-Amplitudengang, der am besten dazu passt

% Zeitkonstante des RC-Tiefpass bestimmen
% Theoretische bertragungsfunktion in rctpAmp
% Startwerte fr die vom Algorithmus gesuchte 
% Vertrkung und Zeitkonstante werden 1 und 0.01 gewhlt
% Frequenzen und gemessene bertragungsfunktion in F und H
% Die Parameter werden bei der Optimierung auf positive
% Werte beschrnkt, da Vertrkung und Zeitkonstante
% positiv sind.
RCTPparams = lsqcurvefit(@rctpAmp,[0.01,1], F, H, [0,0], [inf,inf]);
T = RCTPparams(1); A = RCTPparams(2);
fprintf('\n\nGefundene Zeitkonstante des RC-TP:    %10.6f  sec\n', T);
fprintf('Gefundene Grenzfrequenz des RC-TP:    %10.6f  Hz\n', (1/T)/2/pi);
fprintf('Gefundene Verstrkung des RC-TP bei 0:    %10.6f  \n\n', A);

% Von der Optimierung gefundenen Amplitudengang darstellen
hold
Hth = rctpAmp(RCTPparams, F);
semilogx(F,10*log10(Hth),'r--','LineWidth',2)
axis([10,1000,-20,0])
