function [F, Pxx] = VentilatorPSD(VentiSig,fa,fg,NFFT)
%
% Beispielaufrufe:  
%          [F, PxxVentiV2] = VentilatorPSD(VentiV2,22050,250,16*1024);
%          [F, PxxVentiV2G] = VentilatorPSD(VentiV2G,22050,250,16*1024);
%
% Spektralanalyse eines Ventilatorgerusches. 
% Es wird das Leistungsdichtespektrum des Ventilatorgerusches
% VentiSig bestimmt und grafisch dargestellt.
%
% Eingangsparameter:       VentiSig      das mit make_audio.m aufgenommene
%                                        Ventilatorgerusch
%                          fa            Abtastrate in Hz
%                          fg            Grenzfrequenz in Hz fr die
%                                        grafische Darstellung des 
%                                        Leistungsdichtespektrums
%                          NFFT          Zahl der FFT-Punkte fr die
%                                        Berechnung nach der Welch-Methode
%
% Ausgangsparameter:       keine
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.2
% Datum: 28.11.2014/21.05.2018

% Signal mit detrend um Mittelwert und Tend bereinigen
VentiSig = detrend(VentiSig);

% Leistungsdichtespektrum Eingangssignal berechnen
[Pxx,F] = cpsd(VentiSig,VentiSig,bartlett(NFFT),NFFT/2,NFFT,fa,'onesided');

% Berechnetes Leistungdichtespektrum darstellen
figure
plot(F,10*log10(Pxx),'b','LineWidth',2)
grid
xlabel('Frequenz/Hz')
ylabel('Sxx/W/Hz')
title('Leistungsdichte des Ventilatorgerusches')
axis([0,fa/2,min(10*log10(Pxx))-5,max(10*log10(Pxx))+5])

% Ausschnitt des Leistungdichtespektrums darstellen
figure
plot(F,10*log10(Pxx),'b','LineWidth',2)
grid
xlabel('Frequenz/Hz')
ylabel('Sxx/W/Hz')
title('Leistungsdichte des Ventilatorgerusches')
rel = 2*fg/fa;
mx = max(10*log10(Pxx(1:floor(NFFT/2*rel)+1)));
mn = min(10*log10(Pxx(1:floor(NFFT/2*rel)+1)));
axis([0,fg,mn-5,mx+5])


