% Script YuleWalkFahrbahn.m
%
% Aufruf:  YuleWalkFahrbahn
%
% Es wird mit Hilfe der Yule-Walker-Methode ein Filter
% berechnet, mit dem auf der Grundlage des Wiener-Lee-Theorems
% ein Fahrbahnunebenheitssignal erzeugt werden kann.
%
% Die spektrale Leistungsdichte des zugehrigen 
% zeitkontinuierlichen Signals soll
%
%      S_XX(rho) = (1/rho)^(1.75)
%
% sein (raue Fahrbahn)
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 28.11.2014/21.05.2018

fa = 100;        % Abtastrate in 1/m

F = (0:0.01:0.1);% Frequenzvektor normiert auf die halbe
                 % Abtastrate (1 entspricht fa/2)
F = [F,(0.2:0.1:1)];
                 
Omega = F*pi;    % normierte Frequenz in rad
                 % pi entspricht Abtastrate/2
                 
                 % gewnschte Filtercharakteristik
magn = sqrt(fa)*(1./(Omega*fa)).^(1.75/2); 


magn(1) = magn(2); % da sonst magn(1)=Inf und die
                 % Anpassung schwierig wird
                 
order = 8;       % gewhlte Filterordnung
                 % Berechnung der Filterkoeffizienten
[b,a] = yulewalk(order,F,magn);

                 % Berechnung der Filter-bertragungs-
                 % funktion zur Probe
[H,w] = freqz(b,a,Omega);

                 % Vergleichsplot zur Probe
figure
semilogx(Omega,20*log10(magn), 'b', ...
    Omega,20*log10(abs(H)), 'r:', 'LineWidth', 3)
grid
xlabel('Normierte Frequenz')
ylabel('|H|/dB')
                 
figure
plot(Omega,magn, 'b', ...
    Omega,abs(H), 'r:', 'LineWidth', 3)   
grid
xlabel('Normierte Frequenz')
ylabel('|H|')      
axis([0,pi,0,1])
                 